package cn.dolphin.wechat.core.exception;

import cn.dolphin.core.exception.BaseRuntimeException;

/**
 * 定义微信异常类
 */
public class WxErrorException extends BaseRuntimeException {

    private static final long serialVersionUID = 1L;

    /**
     * 常用异常：微信业务处理异常
     */
    public static final WxErrorException ERROR = new WxErrorException("微信业务处理异常");


    public WxErrorException() {
        super();
    }

    public WxErrorException(String message, Throwable cause, boolean enableSuppression,
                                  boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);

    }

    public WxErrorException(String message, Throwable cause) {
        super(message, cause);

    }

    public WxErrorException(String message) {
        super(message);

    }

    public WxErrorException(Throwable cause) {
        super(cause);

    }


}
