package cn.dolphin.wechat.api.wxopen;

import cn.dolphin.core.exception.ApiException;
import cn.dolphin.https.client.Http;
import cn.dolphin.https.model.HttpResult;
import cn.dolphin.wechat.api.commom.WxBaseAPI;
import cn.dolphin.wechat.core.enums.WechatEnum;
import cn.dolphin.wechat.core.util.Wechatutils;
import cn.dolphin.wechat.wxopen.consts.WxopenTemplateMsgConstant;
import cn.dolphin.wechat.wxopen.model.message.WechatTemplate;

/**
 * 小程序模板
 */
public class WxopenMessageAPI extends WxBaseAPI {

    /**
     * 向用户发送模版消息
     * @param accessToken accessToken
     * @param templateMessage 字段列表
     * @return 消息ID
     */
    public static void sendTemplate(String accessToken, WechatTemplate templateMessage){
        try {
//            Map<String, String> params = buildTemplateParams(openId, templateId, url, templateMessage.getData());
            HttpResult httpResult = Http.getInstance().postJson(WxopenTemplateMsgConstant.TEMPLATE_SEND + accessToken, templateMessage.toJson());
            if(httpResult.getCode()==200){
                // 检查
                Wechatutils.check(httpResult.getContent());
            }else {
                throw new ApiException(WechatEnum.ERROR.code(), WechatEnum.ERROR.msg());
            }
        } catch (Exception e) {
            throw new ApiException(e.getMessage(),e);
        }
    }
}
