package cn.dolphin.wechat.api.wxopen;

import cn.dolphin.core.exception.ApiException;
import cn.dolphin.core.map.StrHashMap;
import cn.dolphin.https.client.Http;
import cn.dolphin.https.model.HttpResult;
import cn.dolphin.wechat.api.commom.WxBaseAPI;
import cn.dolphin.wechat.core.enums.WechatEnum;
import cn.dolphin.wechat.core.util.JsonMapper;
import cn.dolphin.wechat.core.util.Wechatutils;
import cn.dolphin.wechat.wxopen.consts.WxopenCodeConstant;
import cn.dolphin.wechat.wxopen.model.user.Jscode2session;

/**
 * 小程序code
 */
public class WxopenCodeAPI extends WxBaseAPI {

    /**
     * 登录凭证校验
     * @param appid 小程序 appId
     * @param secret 小程序 appSecret
     * @param jsCode 登录时获取的 code
     * @return
     */
    public static Jscode2session getOpenIdByJSCode(String appid,String secret,String jsCode) {

        try {
            StrHashMap params = new StrHashMap();
            params.put("appid", Wechatutils.urlEncode(appid));
            params.put("secret",Wechatutils.urlEncode(secret));
            params.put("js_code",Wechatutils.urlEncode(jsCode));
            params.put("grant_type","authorization_code");// 授权类型，此处只需填写 authorization_code

            HttpResult httpResult = Http.getInstance().get(WxopenCodeConstant.JSCODE2SESSION,params);
            if(httpResult.getCode()==200){
                // 检查
                Wechatutils.check(httpResult.getContent());
                //return JSONObject.parseObject(httpResult.getContent(), UserInfo.class);
                return JsonMapper.defaultMapper().fromJson(httpResult.getContent(), Jscode2session.class);
            }else {
                throw new ApiException(WechatEnum.ERROR.code(), WechatEnum.ERROR.msg());
            }
        } catch (Exception e) {
            throw new ApiException(e.getMessage(),e);
        }

    }



}
