package cn.dolphin.wechat.api.token;

import cn.dolphin.core.cache.ehcache.CacheUtils;
import cn.dolphin.core.exception.ApiException;
import cn.dolphin.core.util.CastUtil;
import cn.dolphin.core.util.EmptyUtil;
import cn.dolphin.core.util.SystemClock;
import cn.dolphin.https.client.Http;
import cn.dolphin.https.model.HttpResult;
import cn.dolphin.wechat.api.commom.WxBaseAPI;
import cn.dolphin.wechat.core.bean.AccessToken;
import cn.dolphin.wechat.core.enums.WechatEnum;
import cn.dolphin.wechat.core.util.JsonMapper;
import cn.dolphin.wechat.core.util.Wechatutils;

import java.util.HashMap;
import java.util.Map;

public class TokenAPI extends WxBaseAPI {


    /**
     * 获取全局token调用凭证
     * @param appid
     * @param secret
     * @return
     */
    public static AccessToken getToken(String appid, String secret){
        return getToken(appid,secret,false);
    }
    /**
     * 获取全局token调用凭证
     * @param appid
     * @param secret
     * @param falg true 开启本地缓存 false 关闭本地缓存
     * @return
     */
    public static AccessToken getToken(String appid, String secret,boolean falg){

        try {
            AccessToken token = new AccessToken();
            // 系统缓存
            if(falg && EmptyUtil.isNotEmpty(CacheUtils.get("accessToken")) && EmptyUtil.isNotEmpty(CacheUtils.get("getTime"))){
                long currentTime = System.currentTimeMillis();
                if((currentTime - CastUtil.castLong(CacheUtils.get("getTime"))) < 7200000) { // 过期了  | access_token有效期为7200秒
                    token.setAccessToken(CacheUtils.get("accessToken"));
                    token.setExpire(7200);
                    return token;
                }
            }

            Map<String,String> params = new HashMap<String, String>();
            params.put("grant_type","client_credential");
            params.put("appid",appid);
            params.put("secret",secret);
            HttpResult httpResult = Http.getInstance().get(TOKEN, params);
            if(httpResult.getCode()==200){
                // 检查
                Wechatutils.check(httpResult.getContent());
                token = JsonMapper.defaultMapper().fromJson(httpResult.getContent(), AccessToken.class);
                if(falg){
                    CacheUtils.put("getTime", SystemClock.now());
                    CacheUtils.put("accessToken",token.getAccessToken());
                }
                return token;
            }else {
                throw new ApiException(WechatEnum.ERROR.code(), WechatEnum.ERROR.msg());
            }
        } catch (Exception e) {
            throw new ApiException(e.getMessage(),e);
        }
    }
}
