package cn.dolphin.wechat.api.mp;

import cn.dolphin.core.exception.ApiException;
import cn.dolphin.core.map.MapUtil;
import cn.dolphin.https.client.Http;
import cn.dolphin.https.model.HttpResult;
import cn.dolphin.wechat.api.commom.WxBaseAPI;
import cn.dolphin.wechat.core.enums.WechatEnum;
import cn.dolphin.wechat.core.util.JsonMapper;
import cn.dolphin.wechat.core.util.Wechatutils;
import cn.dolphin.wechat.mp.consts.TemplateMsgConstant;
import cn.dolphin.wechat.mp.model.message.WxMpTemplateMessage;

import java.util.HashMap;

public class MpMessageAPI extends WxBaseAPI {


    /**
     * 向用户发送模版消息
     * @param accessToken accessToken
     * @param templateMessage 字段列表
     * @return 消息ID
     */
    public static String sendTemplate(String accessToken,WxMpTemplateMessage templateMessage){
        try {
            //Map<String, String> params = buildTemplateParams(openId, templateId, url, templateMessage.getData());
            HttpResult httpResult = Http.getInstance().postJson(TemplateMsgConstant.TEMPLATE_SEND + accessToken, templateMessage.toJson());
            if(httpResult.getCode()==200){
                // 检查
                Wechatutils.check(httpResult.getContent());
                HashMap<String, Object> result = JsonMapper.defaultMapper().json2Map(httpResult.getContent());
                return MapUtil.getString(result,"msgid","0");
            }else {
                throw new ApiException(WechatEnum.ERROR.code(), WechatEnum.ERROR.msg());
            }
        } catch (Exception e) {
            throw new ApiException(e.getMessage(),e);
        }
    }


}
