package cn.dolphin.wechat.api.commom;

import cn.dolphin.core.util.ListUtil;
import cn.dolphin.core.util.StrUtil;
import cn.dolphin.https.json.HttpJson;
import cn.dolphin.wechat.mp.model.message.WxMpTemplateData;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

public abstract class WxBaseAPI {

    protected static final String TOKEN = "https://api.weixin.qq.com/cgi-bin/token";



    /**
     * 组装公众号模板绑定参数
     * @param openId
     * @param templateId
     * @param url
     * @param dataList
     * @return
     */
    protected static Map<String, String> buildTemplateParams(String openId, String templateId, String url, List<WxMpTemplateData> dataList) {
        Map<String, Object> params = Maps.newHashMapWithExpectedSize(4);
        params.put("touser", openId);
        params.put("template_id", templateId);
        if (StrUtil.isNotBlank(url)){
            params.put("url", url);
        }
        if (ListUtil.isNotEmpty(dataList)){
            Map<String, Map<String, String>> data = Maps.newHashMapWithExpectedSize(dataList.size());
            Map<String, String> dataItem;
            for (WxMpTemplateData field : dataList){
                dataItem = Maps.newHashMapWithExpectedSize(2);
                dataItem.put("value", field.getValue());
                dataItem.put("color", field.getColor());
                data.put(field.getName(), dataItem);
            }
            params.put("data", data);
        }
        return HttpJson.conversion(params,Map.class);
    }
}
