package cn.dolphin.thread.listener;

import cn.dolphin.thread.ThreadPoolManager;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * 关闭多线程池监听
 * 在应用的启动的时候执行线程池的初始化操作。
 * 在应用关闭时执行线程池的资源释放操作，释放资源的过程会将队列中的异步任务都执行完成
 */
@Slf4j
public class ThreadPoolListener implements ServletContextListener {

    public ThreadPoolListener() {
        super();
    }

    /**
     * 当Servlet 容器启动Web 应用时调用该方法。在调用完该方法之后，容器再对Filter 初始化，
     * 并且对那些在Web 应用启动时就需要被初始化的Servlet 进行初始化。
     * @param sce
     */
    @Override
    public void contextInitialized(ServletContextEvent sce) {
        // 在应用的启动的时候执行线程池的初始化操作。
        ThreadPoolManager tpm = ThreadPoolManager.getSingleton();
        tpm.init();
        log.info("@Springboot Starting [线程池初始化资源] ");
    }

    /**
     * 当Servlet 容器终止Web 应用时调用该方法。在调用该方法之前，容器会先销毁所有的Servlet 和Filter 过滤器。
     * @param sce
     */
    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        // 在应用关闭时执行线程池的资源释放操作，释放资源的过程会将队列中的异步任务都执行完成
        ThreadPoolManager tpm = ThreadPoolManager.getSingleton();
        tpm.destroy();
        log.info("@Springboot Starting [线程池释放资源] ");
    }
}
