package cn.dolphin.https.json.jackson;

import cn.dolphin.https.convert.impl.StringToDate;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import java.io.IOException;
import java.util.Date;

/**
 * json转换日期
 */
public class JsonDateDeserializer extends JsonDeserializer<Date> {
    private static final StringToDate stringToDate = new StringToDate();

    @Override
    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String dateStr = jp.getText();
        return stringToDate.convert(dateStr);
    }
}