package cn.dolphin.https.common;

import cn.dolphin.https.model.HttpResult;
import org.apache.http.HttpStatus;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.impl.client.CloseableHttpClient;

import java.util.Map;

/**
 * 发送put请求
 */
public class Put extends Request<Put>{

    /**
     * 当前对象实例
     */
    private static volatile Put put = null;


    /**
     * 静态工厂方法 获取当前对象实例 多线程安全单例模式(使用双重同步锁)
     */

    public static Put getInstance() {
        if (put == null) {
            synchronized (Put.class) {
                if (put == null)
                    put = new Put();
            }
        }
        return put;
    }

    public Put() {
        super();
    }



    /**
     * 发送put请求；带请求参数
     * 表单提交
     * @param url 请求地址
     * @param params 请求参数集合
     * @param connectTimeout 设置连接超时时间，单位毫秒
     * @param readTimeout 请求获取数据的超时时间(即响应时间)，单位毫秒
     * @return
     * @throws Exception
     */
    public HttpResult doPut(String url, Map<String, String> params, int connectTimeout, int readTimeout){
        try {
            // 创建httpClient对象
            CloseableHttpClient httpClient = getHttpClient();
            // 创建http对象
            HttpPut httpPut = new HttpPut(url);
            /**
             * setConnectTimeout：设置连接超时时间，单位毫秒。
             * setConnectionRequestTimeout：设置从connect Manager(连接池)获取Connection
             * 超时时间，单位毫秒。这个属性是新加的属性，因为目前版本是可以共享连接池的。
             * setSocketTimeout：请求获取数据的超时时间(即响应时间)，单位毫秒。 如果访问一个接口，多少时间内无法返回数据，就直接放弃此次调用。
             */
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((connectTimeout == 0 ? CONNECT_TIMEOUT : connectTimeout)).setSocketTimeout((readTimeout == 0 ? SOCKET_TIMEOUT : readTimeout)).build();
            httpPut.setConfig(requestConfig);
            httpPut.addHeader(jsonHeader);

            // 封装请求参数
            packageParam(params, httpPut);
            // 执行请求并获得响应结果
            return getHttpClientResult(httpClient, httpPut);
        } catch (Exception e) {
            return new HttpResult(HttpStatus.SC_INTERNAL_SERVER_ERROR);
        } finally {
            // 释放资源
            //close2();
        }
    }



}
