package cn.dolphin.https.common;

import cn.dolphin.https.model.HttpResult;
import org.apache.http.Consts;
import org.apache.http.HttpStatus;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HTTP;

import java.net.URLEncoder;
import java.util.Map;

/**
 * post请求json封装
 */
public class PostJson extends Request<PostJson> {

    /**
     * 当前对象实例
     */
    private static volatile PostJson postJson = null;


    /**
     * 静态工厂方法 获取当前对象实例 多线程安全单例模式(使用双重同步锁)
     */

    public static PostJson getInstance() {
        if (postJson == null) {
            synchronized (PostJson.class) {
                if (postJson == null)
                    postJson = new PostJson();
            }
        }
        return postJson;
    }

    public PostJson() {
        super();
    }

//    public PostJson(ConnectPool connectPool) {
//        super(connectPool);
//    }


    /**
     * 发送post请求；带请求头和请求参数
     * 表单提交
     * @param url 请求地址
     * @param headers 请求头集合
     * @param params 请求参数集合
     * @param connectTimeout 设置连接超时时间，单位毫秒
     * @param readTimeout 请求获取数据的超时时间(即响应时间)，单位毫秒
     * @return
     * @throws Exception
     */
    public HttpResult doPost(String url, Map<String, String> headers, Map<String, String> params, int connectTimeout, int readTimeout){
        try {
            // 创建httpClient对象
            CloseableHttpClient httpClient = getHttpClient();
            // 创建http对象
            HttpPost httpPost = new HttpPost(url);
            /**
             * setConnectTimeout：设置连接超时时间，单位毫秒。
             * setConnectionRequestTimeout：设置从connect Manager(连接池)获取Connection
             * 超时时间，单位毫秒。这个属性是新加的属性，因为目前版本是可以共享连接池的。
             * setSocketTimeout：请求获取数据的超时时间(即响应时间)，单位毫秒。 如果访问一个接口，多少时间内无法返回数据，就直接放弃此次调用。
             */
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((connectTimeout == 0 ? CONNECT_TIMEOUT : connectTimeout)).setSocketTimeout((readTimeout == 0 ? SOCKET_TIMEOUT : readTimeout)).build();
            httpPost.setConfig(requestConfig);
            httpPost.addHeader(jsonHeader);
            // 设置请求头
            packageHeader(headers, httpPost);
            // 封装请求参数
            packageJsonParam(params, httpPost);
            // 执行请求并获得响应结果
            return getHttpClientResult(httpClient, httpPost);
        } catch (Exception e) {
            return new HttpResult(HttpStatus.SC_INTERNAL_SERVER_ERROR);
        } finally {
            // 释放资源
            //close2();
        }
    }


    /**
     * 发送post请求；带请求头和请求参数
     * 表单提交
     * @param url 请求地址
     * @param headers 请求头集合
     * @param json 请求参数集合
     * @param connectTimeout 设置连接超时时间，单位毫秒
     * @param readTimeout 请求获取数据的超时时间(即响应时间)，单位毫秒
     * @return
     * @throws Exception
     */
    public HttpResult doPost(String url, Map<String, String> headers, String json, int connectTimeout, int readTimeout){
        try {
            // 创建httpClient对象
            CloseableHttpClient httpClient = getHttpClient();
            // 创建http对象
            HttpPost httpPost = new HttpPost(url);
            /**
             * setConnectTimeout：设置连接超时时间，单位毫秒。
             * setConnectionRequestTimeout：设置从connect Manager(连接池)获取Connection
             * 超时时间，单位毫秒。这个属性是新加的属性，因为目前版本是可以共享连接池的。
             * setSocketTimeout：请求获取数据的超时时间(即响应时间)，单位毫秒。 如果访问一个接口，多少时间内无法返回数据，就直接放弃此次调用。
             */
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((connectTimeout == 0 ? CONNECT_TIMEOUT : connectTimeout)).setSocketTimeout((readTimeout == 0 ? SOCKET_TIMEOUT : readTimeout)).build();
            httpPost.setConfig(requestConfig);
            httpPost.addHeader(jsonHeader);
            // 设置请求头
            packageHeader(headers, httpPost);
            // 封装请求参数
            //packageJsonParam(URLEncoder.encode(json,Consts.UTF_8.name()), httpPost); 导致微信请求接口解析json失败
            packageJsonParam(json, httpPost);
            // 执行请求并获得响应结果
            return getHttpClientResult(httpClient, httpPost);
        } catch (Exception e) {
            return new HttpResult(HttpStatus.SC_INTERNAL_SERVER_ERROR);
        } finally {
            // 释放资源
            //close2();
        }
    }




}
