package cn.dolphin.https.common;

import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

/**
 * 检测连接
 */
public class Ping extends Request<Ping>{

    /**
     * 当前对象实例
     */
    private static volatile Ping ping = null;


    /**
     * 静态工厂方法 获取当前对象实例 多线程安全单例模式(使用双重同步锁)
     */

    public static Ping getInstance() {
        if (ping == null) {
            synchronized (Ping.class) {
                if (ping == null)
                    ping = new Ping();
            }
        }
        return ping;
    }

    public Ping() {
        super();
    }


    /**
     * 检测连接
     * @param url
     * @return
     */
    public boolean ping(String url){
        try {
            // 创建httpClient对象
            CloseableHttpClient httpClient = getHttpClient();
            HttpGet http = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute(http);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseString = EntityUtils.toString(response.getEntity(), "UTF-8");
            return statusCode==200&&responseString!=null&&responseString.length()>0;
        } catch (Exception e) {
            logger.error("检测连接异常",e);
            return false;
        }
    }

}
