package cn.dolphin.https.common;

import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * 文件处理
 */
public class Multipart extends Request<Multipart>{

    /**
     * 当前对象实例
     */
    private static volatile Multipart multipart = null;


    /**
     * 静态工厂方法 获取当前对象实例 多线程安全单例模式(使用双重同步锁)
     */

    public static Multipart getInstance() {
        if (multipart == null) {
            synchronized (Multipart.class) {
                if (multipart == null)
                    multipart = new Multipart();
            }
        }
        return multipart;
    }

    public Multipart() {
        super();
    }


    /**
     * 文件上传
     * @param url 上传路径
     * @param file 上传文件
     * @return
     */
    public String upload(String url, File file) {
        List<File> files=new ArrayList<File>();
        files.add(file);
        return uploads(url, files, null);
    }
    /**
     * 文件上传
     * @param url 上传路径
     * @param params 参数
     * @return
     */
    public String upload(String url,Map<String, String> params) {
        try {
            CloseableHttpClient httpClient = getHttpClient();
            HttpPost httpPost = new HttpPost(url);

            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            // 封装参数
            if (params != null && params.size() > 0) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if(value instanceof File){
                        File file=(File)value;
                        //builder.addBinaryBody( key, file, ContentType.MULTIPART_FORM_DATA, file.getName());
                        builder.addPart(key, new FileBody(file));
                    }else{
                        if(value!=null){
                            builder.addTextBody(key,value.toString(), ContentType.create("application/x-www-form-urlencoded", ENCODING));
                        }
                    }
                }
            }
            builder.setCharset(Charset.forName(ENCODING));
            builder.setContentType(ContentType.MULTIPART_FORM_DATA);
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            CloseableHttpResponse response = httpClient.execute(httpPost);
            return EntityUtils.toString(response.getEntity(), ENCODING);
        } catch (ClientProtocolException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 文件上传
     * @param url 上传路径
     * @param files 上传文件
     * @param params 参数
     * @return
     */
    public String uploads(String url, List<File> files, Map<String, String> params) {
        try {
            CloseableHttpClient httpClient = getHttpClient();
            HttpPost httpPost = new HttpPost(url);

            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            // 封装文件
            if (files != null && files.size() > 0) {
                for (File file : files) {
                    builder.addBinaryBody(UUID.randomUUID().toString(), file, ContentType.MULTIPART_FORM_DATA, file.getName());
                }
            }
            // 封装参数
            if (params != null && params.size() > 0) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    builder.addTextBody(entry.getKey(), entry.getValue().toString(),
                            ContentType.create("application/x-www-form-urlencoded", ENCODING));
                }
            }
            builder.setCharset(Charset.forName(ENCODING));
            builder.setContentType(ContentType.MULTIPART_FORM_DATA);
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            CloseableHttpResponse response = httpClient.execute(httpPost);
            return EntityUtils.toString(response.getEntity(), ENCODING);
        } catch (ClientProtocolException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 执行文件下载
     * @param remoteFileUrl 远程下载文件地址
     * @param localFilePath 本地存储文件地址
     * @return
     * @throws Exception
     */
    public boolean download(String remoteFileUrl, String localFilePath)throws Exception{
        CloseableHttpResponse response = null;
        InputStream in = null;
        FileOutputStream fout = null;
        try {
            // 创建httpClient对象
            CloseableHttpClient httpClient = getHttpClient();
            HttpGet httpget = new HttpGet(remoteFileUrl);
            response = httpClient.execute(httpget);
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return false;
            }
            in = entity.getContent();
            File file = new File(localFilePath);
            fout = new FileOutputStream(file);
            int l;
            byte[] tmp = new byte[1024];
            while ((l = in.read(tmp)) != -1) {
                fout.write(tmp, 0, l);
                // 注意这里如果用OutputStream.write(buff)的话，图片会失真
            }
            // 将文件输出到本地
            fout.flush();
            EntityUtils.consume(entity);
            return true;
        }catch (Exception e){
            return false;
        }finally {
            // 关闭低层流。
            if (fout != null) {
                try {
                    fout.close();
                } catch (Exception e) {
                }
            }
            if (response != null) {
                try {
                    response.close();
                } catch (Exception e) {
                }
            }
        }
    }

}
