package cn.dolphin.https.common;

import cn.dolphin.https.model.HttpResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpStatus;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

import java.util.Map;
import java.util.Set;

/**
 * get请求封装
 */
@Slf4j
public class Get extends Request<Get>{


    /**
     * 当前对象实例
     */
    private static volatile Get get = null;


    /**
     * 静态工厂方法 获取当前对象实例 多线程安全单例模式(使用双重同步锁)
     */

    public static Get getInstance() {
        if (get == null) {
            synchronized (Get.class) {
                if (get == null)
                    get = new Get();
            }
        }
        return get;
    }

    public Get() {
        super();
    }
//    public Get(ConnectPool connectPool) {
//        super(connectPool);
//    }

    /**
     * 发送get请求；带请求头和请求参数
     * @param url 请求地址
     * @param headers 请求头集合
     * @param params 请求参数集合
     * @param connectTimeout 设置连接超时时间，单位毫秒
     * @param readTimeout 请求获取数据的超时时间(即响应时间)，单位毫秒
     */
    public HttpResult doGet(String url, Map<String, String> headers, Map<String, String> params, int connectTimeout, int readTimeout){
        try {
            // 创建httpClient对象
            CloseableHttpClient httpClient = getHttpClient();
            // 创建访问的地址
            URIBuilder uriBuilder = new URIBuilder(url);
            if (params != null) {
                Set<Map.Entry<String, String>> entrySet = params.entrySet();
                for (Map.Entry<String, String> entry : entrySet) {
                    uriBuilder.setParameter(entry.getKey(), entry.getValue());
                }
            }
            // 创建http对象
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            /**
             * setConnectTimeout：设置连接超时时间，单位毫秒。
             * setConnectionRequestTimeout：设置从connect Manager(连接池)获取Connection
             * 超时时间，单位毫秒。这个属性是新加的属性，因为目前版本是可以共享连接池的。
             * setSocketTimeout：请求获取数据的超时时间(即响应时间)，单位毫秒。 如果访问一个接口，多少时间内无法返回数据，就直接放弃此次调用。
             */
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((connectTimeout==0?CONNECT_TIMEOUT:connectTimeout)).setSocketTimeout((readTimeout==0?SOCKET_TIMEOUT:readTimeout)).build();
            httpGet.setConfig(requestConfig);
            // 设置请求头
            packageHeader(headers, httpGet);
            // 执行请求并获得响应结果
            return getHttpClientResult(httpClient, httpGet);
        }catch (Exception e){
            return new HttpResult(HttpStatus.SC_INTERNAL_SERVER_ERROR);
        }finally {
            // 释放资源
            //close2();
        }
    }


}
