package cn.dolphin.https.client;

import cn.dolphin.https.base.ConnectPool;
import cn.dolphin.https.common.*;
import cn.dolphin.https.json.HttpJson;
import cn.dolphin.https.model.HttpResult;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;

import java.util.HashMap;
import java.util.Map;

/**
 * HTTP请求客户端
 */
@SuppressWarnings("all")
public class Http extends Request<Http> {

    /**
     * 当前对象实例
     */
    private static volatile Http http = null;


    /**
     * 静态工厂方法 获取当前对象实例 多线程安全单例模式(使用双重同步锁)
     */
    public static Http getInstance() {
        if (http == null) {
            synchronized (Http.class) {
                if (http == null)
                    http = new Http(null);
            }
        }
        return http;
    }


    /**
     * 静态工厂方法 获取当前对象实例 多线程安全单例模式(使用双重同步锁)
     */
    public static Http getInstance(ConnectPool connectPool) {
        if (http == null) {
            synchronized (Http.class) {
                if (http == null)
                    http = new Http(connectPool);
            }
        }
        return http;
    }


    /**
     * 集成spring的bean注入管理链接池
     * @param connectPool
     */
    public Http(ConnectPool connectPool) {
        super(connectPool);
    }


    /**
     * 发送get请求
     * @param url 请求地址
     */
    public HttpResult get(String url)throws Exception{
        return get(url, null,null,0,0);
    }

    /**
     * 发送get请求
     * @param url 请求地址
     * @param params 请求参数集合
     */
    public HttpResult get(String url, Map<String, String> params)throws Exception{
        return get(url, null,params,0,0);
    }

    /**
     * 发送get请求
     * @param url 请求地址
     * @param headers 请求头集合
     * @param params 请求参数集合
     */
    public HttpResult get(String url, Map<String, String> headers, Map<String, String> params)throws Exception{
        return get(url, headers,params,0,0);
    }

    /**
     * 发送get请求
     * @param url 请求地址
     * @param headers 请求头集合
     * @param params 请求参数集合
     * @param connectTimeout 设置连接超时时间，单位毫秒
     * @param readTimeout 请求获取数据的超时时间(即响应时间)，单位毫秒
     */
    public HttpResult get(String url, Map<String, String> headers, Map<String, String> params, int connectTimeout, int readTimeout)throws Exception {
        logger.info(String.format("网络请求地址:{%s}",url));
        try {
            return Get.getInstance().doGet(url,headers,params,connectTimeout,readTimeout);
        } catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }


    /**
     * 发送post请求
     * @param url 请求地址
     */
    public HttpResult post(String url)throws Exception{
        return post(url, null,null,0,0);
    }

    /**
     * 发送post请求
     * @param url 请求地址
     * @param params 请求参数集合
     */
    public HttpResult post(String url, Map<String, String> params)throws Exception{
        return post(url, null,params,0,0);
    }


    /**
     * 发送post请求
     * @param url 请求地址
     * @param headers 请求头集合
     * @param params 请求参数集合
     */
    public HttpResult post(String url, Map<String, String> headers, Map<String, String> params)throws Exception{
        return post(url, headers,params,0,0);
    }

    /**
     * 发送post请求
     * @param url 请求地址
     * @param headers 请求头集合
     * @param params 请求参数集合
     * @param connectTimeout 设置连接超时时间，单位毫秒
     * @param readTimeout 请求获取数据的超时时间(即响应时间)，单位毫秒
     */
    public HttpResult post(String url, Map<String, String> headers, Map<String, String> params, int connectTimeout, int readTimeout)throws Exception {
        logger.info(String.format("网络请求地址:{%s}",url));
        try {
            return Post.getInstance().doPost(url,headers,params,connectTimeout,readTimeout);
        } catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    /**
     * 发送postJson请求
     * @param url 请求地址
     * @param json 请求参数集合
     */
    public HttpResult postJson(String url,String json)throws Exception{
        return postJson(url, null,json,0,0);
    }

    /**
     * 发送postJson请求
     * @param url 请求地址
     * @param params 请求参数集合
     */
    public HttpResult postJson(String url, Map<String, String> params)throws Exception{
        return postJson(url, null,params,0,0);
    }


    /**
     * 发送postJson请求
     * @param url 请求地址
     * @param headers 请求头集合
     * @param json 请求参数集合
     */
    public HttpResult postJson(String url, Map<String, String> headers, String json)throws Exception{
        return postJson(url, headers,json,0,0);
    }


    /**
     * 发送postJson请求
     * @param url 请求地址
     * @param headers 请求头集合
     * @param params 请求参数集合
     */
    public HttpResult postJson(String url, Map<String, String> headers, Map<String, String> params)throws Exception{
        return postJson(url, headers,params,0,0);
    }

    /**
     * 发送post请求；带请求头和请求参数
     * 表单提交
     * @param url 请求地址
     * @param headers 请求头集合
     * @param json 请求参数集合
     * @param connectTimeout 设置连接超时时间，单位毫秒
     * @param readTimeout 请求获取数据的超时时间(即响应时间)，单位毫秒
     * @return
     * @throws Exception
     */
    public HttpResult postJson(String url, Map<String, String> headers, String json, int connectTimeout, int readTimeout)throws Exception{
        logger.info(String.format("网络请求地址:{%s}",url));
        try {
            return PostJson.getInstance().doPost(url,headers,json,connectTimeout,readTimeout);
        } catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    /**
     * 发送postJson请求
     * @param url 请求地址
     * @param headers 请求头集合
     * @param params 请求参数集合
     * @param connectTimeout 设置连接超时时间，单位毫秒
     * @param readTimeout 请求获取数据的超时时间(即响应时间)，单位毫秒
     */
    public HttpResult postJson(String url, Map<String, String> headers, Map<String, String> params, int connectTimeout, int readTimeout)throws Exception {
        logger.info(String.format("网络请求地址:{%s}",url));
        try {
            return PostJson.getInstance().doPost(url,headers,params,connectTimeout,readTimeout);
        } catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }


    /**
     * 发送postXml请求
     * @param url 请求地址
     */
    public HttpResult postXml(String url)throws Exception{
        return postXml(url, null,null,0,0);
    }

    /**
     * 发送postXml请求
     * @param url 请求地址
     * @param params 请求参数集合
     */
    public HttpResult postXml(String url, Map<String, String> params)throws Exception{
        return postXml(url, null,params,0,0);
    }


    /**
     * 发送postXml请求
     * @param url 请求地址
     * @param headers 请求头集合
     * @param params 请求参数集合
     */
    public HttpResult postXml(String url, Map<String, String> headers, Map<String, String> params)throws Exception{
        return postXml(url, headers,params,0,0);
    }

    /**
     * 发送postXml请求
     * @param url 请求地址
     * @param headers 请求头集合
     * @param params 请求参数集合
     * @param connectTimeout 设置连接超时时间，单位毫秒
     * @param readTimeout 请求获取数据的超时时间(即响应时间)，单位毫秒
     */
    public HttpResult postXml(String url, Map<String, String> headers, Map<String, String> params, int connectTimeout, int readTimeout)throws Exception {
        logger.info(String.format("网络请求地址:{%s}",url));
        try {
            return PostXml.getInstance().doPost(url,headers,params,connectTimeout,readTimeout);
        } catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    /**
     * 发送put请求；不带请求参数
     *
     * @param url 请求地址
     * @return
     * @throws Exception
     */
    public HttpResult doPut(String url) throws Exception {
        return doPut(url,null);
    }


    /**
     * 发送put请求；不带请求参数
     *
     * @param url 请求地址
     * @param params 参数集合
     * @return
     * @throws Exception
     */
    public HttpResult doPut(String url,Map<String, String> params) throws Exception {
        return doPut(url,params);
    }


    /**
     * 发送put请求；带请求参数
     * @param url 请求地址
     * @param params 请求参数集合
     * @param connectTimeout 设置连接超时时间，单位毫秒
     * @param readTimeout 请求获取数据的超时时间(即响应时间)，单位毫秒
     */
    public HttpResult put(String url,Map<String, String> params, int connectTimeout, int readTimeout)throws Exception {
        logger.info(String.format("网络请求地址:{%s}",url));
        try {
            return Put.getInstance().doPut(url,params,connectTimeout,readTimeout);
        } catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }


    /**
     * 发送delete请求；带请求参数
     *
     * @param url 请求地址
     * @return
     * @throws Exception
     */
    public HttpResult doDelete(String url)throws Exception{
        logger.info(String.format("网络请求地址:{%s}",url));
        return Delete.getInstance().doDelete(url, 0,0);
    }

    /**
     * 发送delete请求；带请求参数
     *
     * @param url 请求地址
     * @param params 参数集合
     * @return
     * @throws Exception
     */
    public HttpResult doDelete(String url, Map<String, String> params) throws Exception {
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("_method", "delete");
        return post(url, params);
    }

    /**
     * 检测连接
     * @param url 请求地址
     * @return
     * @throws Exception
     */
    public boolean ping(String url)throws Exception{
        logger.info(String.format("网络请求地址:{%s}",url));
        return Ping.getInstance().ping(url);
    }

    /**
     * 把返回数据转换为指定对象
     * @param response
     * @param type
     * @return
     */
    public <T> T responseDataConversion(HttpResponse response, Class<T> type) {
        return super.responseDataConversion(response,type);
    }


    /**
     * 把返回数据转换为指定对象
     * @param entityString
     * @param type
     * @param <T>
     * @return
     */
    public <T> T responseDataConversion(String entityString, Class<T> type) {
        if (entityString == null) {
            return null;
        }
        return HttpJson.conversion(entityString, type);
    }





    public static void main(String[] args)throws Exception {

        int code = (int)((Math.random()*9+1)*100000);//验证码
        StringBuilder content = new StringBuilder();
        content.append("第三方登录授权绑定，您的验证码是：");
        content.append(code);
        content.append("。请不要把验证码泄漏给其他人。");
        String Url = "http://106.ihuyi.com/webservice/sms.php?method=Submit";
        Map<String,String> sms = new HashMap<String, String>();
        sms.put("account", "cf_jieli");
        sms.put("password", "8315d0a58a96b922c34bb833fa8068a1");
        sms.put("mobile","18645203099");
        sms.put("content",content.toString());
        HttpResult httpResult =  Http.getInstance().postXml(Url,sms);
        System.out.println(httpResult);


//        System.out.println(Http.getInstance().ping("https://api.java.tiennet.com/address/userAddress"));
//        // HttpResult get =Http.get("https://api.java.tiennet.com/address/userAddress");
//        //HttpResult get1 =Http.get("https://api.java.tiennet.com/address/userAddress");
//        Map<String, String> params = new HashMap<String, String>();
//        params.put("user_id","22");
//        //HttpResult post = Http.getInstance().post("https://api.java.tiennet.com/user/getFootClassify",params);
////        System.out.println(post);
////        System.out.println(get.getCode());
////        System.out.println(get.getContent());
//        params.put("userId","212");
//        Map<String, String> headers= new HashMap<String, String>();
//        headers.put("token","a6e1fe8cd83a53b81acb3ffd2090fbd8");
//        HttpResult json = Http.getInstance().postJson("http://127.0.0.1:20112/project/detail/getProjectDetailList",headers,params);
//        // 处理转换结果
//        Map map = Http.getInstance().responseDataConversion(json.getContent(),Map.class);
//        System.out.println(map);
    }

}
