package cn.dolphin.email.util;

import javax.mail.Address;
import javax.mail.internet.InternetAddress;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 邮件工具类
 */
public class MailUtil {

    /**
     * 校验邮箱格式是否正确
     * @param mailString 待判断的mail邮件地址
     * @return boolean 是否匹配成功
     */
    public static boolean isMailAddr(String mailString) {
        String pattenString =
                "^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$";
        Pattern pattern=Pattern.compile(pattenString);
        Matcher matcher=pattern.matcher(mailString);
        return matcher.matches();
    }

    /**
     * 邮件激活验证码生成code
     * @param num 验证码随机数的位数
     * @return String 随机数
     */
    public static String  getVCode(int num) {
        Random random=new Random();
        StringBuffer stringBuffer=new StringBuffer("");
        for (int i = 0; i < num; i++) {
            stringBuffer.append(random.nextInt(10));
        }
        return stringBuffer.toString();
    }

    /**
     * 得到收件人信息
     * @param receiver 收件人
     *            收件人地址
     * @return InternetAddress[]
     * @throws Exception
     */
    public static InternetAddress[] getReceivers(String... receiver){
        try {
            if (receiver.length < 0) {
                throw new RuntimeException("收件人为空");
            }
            // 将字符串数组转为收件人数组
            InternetAddress[] receiverArray = new InternetAddress[receiver.length];
            for (int i = 0; i < receiverArray.length; i++) {
                receiverArray[i] = new InternetAddress(receiver[i]);
            }
            return receiverArray;
        }catch (Exception e){
            InternetAddress[] receiverArray = new InternetAddress[0];
            return receiverArray;
        }
    }

    /**
     * 地址数据转化为字符串数组
     * @param addresss
     * @return
     */
    public static String[] addressToString(Address[] addresss) {
        if (addresss == null || addresss.length == 0) {
            return null;
        }

        String[] adds = new String[addresss.length];

        for (int i = 0; i < addresss.length; i++) {
            adds[i] = addresss[i].toString();
        }
        return adds;
    }



}
