package cn.dolphin.email.entity;

import lombok.Data;

import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import java.io.Serializable;

/**
 * 服务器邮箱登录验证
 */
@Data
public class EmailAuthenticator extends Authenticator implements Serializable {

    private static final long serialVersionUID = 2375970868442356042L;

    /**
     * 邮件服务器
     */
    private String host;
    /**
     * 用户名（登录邮箱）
     */
    private String username;
    /**
     * 密码
     */
    private String password;

    /**
     * 邮件模板ftl路径
     */
    private String templatePath ;


    /**
     * 初始化邮箱和密码
     * @param username 邮箱
     * @param password 密码
     * @param host 邮件服务器
     */
    public EmailAuthenticator(String username, String password,String host) {
        this.host = host;
        this.username = username;
        this.password = password;
    }

    /**
     * 初始化邮箱和密码
     * @param username 邮箱
     * @param password 密码
     * @param host 邮件服务器
     * @param templatePath 邮件模板ftl路径
     */
    public EmailAuthenticator(String username, String password,String host,String templatePath) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.templatePath = templatePath;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(username, password);
    }
}
