package cn.dolphin.core.web.util;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

import cn.dolphin.core.consts.CharsetConstant;
import cn.dolphin.core.consts.StringConstant;
import cn.dolphin.core.exception.IoRuntimeException;
import cn.dolphin.core.spring.SpringContextUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.ResourceUtils;


/**
 * 消息操作类
 */
@SuppressWarnings("all")
public class ResourceUtil {

    private static final Logger log = LoggerFactory.getLogger(ResourceUtil.class);

    /**
     * 取得资源键值
     * @param msgKey
     * @param arg
     * @param local
     * @return
     */
    public static String getText(String msgKey,Object arg,Locale local) {
        MessageSource messageSource=(MessageSource) SpringContextUtil.getBean(MessageSource.class);
        return messageSource.getMessage(msgKey,new Object[]{ arg}, local);
    }

    /**
     * 取得资源键值
     * @param msgKey
     * @param args
     * @param local
     * @return
     */
    public static String getText(String msgKey,Object[] args,Locale local) {
        MessageSource messageSource=(MessageSource)SpringContextUtil.getBean(MessageSource.class);
        return messageSource.getMessage(msgKey,args, local);
    }

    /**
     * 读取Classpath下的资源文件
     *
     * @param path  基于classpath的相对路径，如"resource/xx.txt"
     * @return  资源不存在返回null
     *
     */
    public static InputStream getIns(String path){
        //读取本地资源：基于Classpath
        ClassPathResource classPathResource = new ClassPathResource(path);
        try {
            return classPathResource.getInputStream();
        } catch (IOException e) {
            // 文件不存在
            log.warn("读取文件 classpath:{}"+"失败：{}",path, e.getMessage());
            return null;
        }
    }
    /**
     *
     * 读取Classpath下的资源文件
     *
     * @param path  基于classpath的相对路径，如"resource/xx.txt"
     * @return  资源不存在返回null
     *
     */
    public static File getFile(String path){
        try {
            //读取本地资源：基于Classpath
            return ResourceUtils.getFile("classpath:"+path);
        } catch (FileNotFoundException e) {
            // 文件不存在
            log.warn("读取文件 classpath:{}"+"失败：{}",path, e.getMessage());
            return null;
        }
    }

    /**
     *
     * 读取Classpath下的资源文件
     *
     * @param path  基于classpath的相对路径，如"resource/xx.txt"
     * @return  资源不存在返回null
     *
     */
    public static Resource getResource(String path){
        //资源解析器
        ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        //读取本地资源：基于Classpath
        Resource resource = resolver.getResource("classpath:"+path);
        //判断资源是否存在
        boolean exists = resource.exists();
        if(!exists){
            log.warn("未找到配置文件 classpath:"+path);
            return null;
        }
        return resource;
    }

    /**
     *
     * 读取资源为String，忽略行首为 #的注释
     *
     * @param path  基于classpath的相对路径，如"resource/xx.txt"
     * @return  资源不存在返回null
     *
     */
    public static final String readStr(String path){
        //获取资源
        Resource resource = getResource(path);
        if(resource == null){
            return null;
        }
        //获取资源的读取流
        InputStream inputStream = null;
        BufferedReader br = null;
        try{
            inputStream = resource.getInputStream();
            br = new BufferedReader(new InputStreamReader(inputStream, CharsetConstant.UTF8));
            //读取资源
            StringBuilder sb = new StringBuilder();
            String line = StringConstant.EMPTY;
            while((line = br.readLine()) != null){
                line = StringUtils.trimToEmpty(line);
                if (!line.equals(StringConstant.EMPTY) && ! line.startsWith(StringConstant.HASH)) {
                    sb.append(line);
                }
            }
            return sb.toString();
        }catch(IOException e){
            throw new IoRuntimeException("读取资源失败：classpath:"+path, e);
        }finally{
            try {
                inputStream.close();
                br.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     *
     * 读取资源为List，忽略行首为 #的注释
     *
     * @param path  基于classpath的相对路径，如"resource/xx.txt"
     * @return  资源不存在返回null
     *
     */
    public static final ArrayList<String> readList(String path){
        //获取资源
        Resource resource = getResource(path);
        if(resource == null){
            return null;
        }
        //获取资源的读取流
        InputStream inputStream = null;
        BufferedReader br = null;
        try{
            inputStream = resource.getInputStream();
            br = new BufferedReader(new InputStreamReader(inputStream,CharsetConstant.UTF8));
            //读取资源
            ArrayList<String> list = new ArrayList<String>();
            String line = StringConstant.EMPTY;
            while((line = br.readLine()) != null){
                line = StringUtils.trimToEmpty(line);
                if (!line.equals(StringConstant.EMPTY) && ! line.startsWith(StringConstant.HASH)) {
                    list.add(line);
                }
            }
            return list;
        }catch(IOException e){
            throw new IoRuntimeException("读取资源失败：classpath:"+path, e);
        }finally{
            try {
                inputStream.close();
                br.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
    /**
     *
     * 读取资源为Set，忽略行首为 #的注释
     *
     * @param path  基于classpath的相对路径，如"resource/xx.txt"
     * @return 资源不存在返回null
     *
     */
    public static final HashSet<String> readSet(String path){
        //获取资源
        Resource resource = getResource(path);
        if(resource == null){
            return null;
        }
        //获取资源的读取流
        InputStream inputStream = null;
        BufferedReader br = null;
        try{
            inputStream = resource.getInputStream();
            br = new BufferedReader(new InputStreamReader(inputStream,CharsetConstant.UTF8));
            //读取资源
            HashSet<String> set = new HashSet<String>();
            String line = StringConstant.EMPTY;
            while((line = br.readLine()) != null){
                line = StringUtils.trimToEmpty(line);
                if (!line.equals(StringConstant.EMPTY) && ! line.startsWith(StringConstant.HASH)) {
                    set.add(line);
                }
            }
            return set;
        }catch(IOException e){
            throw new IoRuntimeException("读取资源失败：classpath:"+path, e);
        }finally{
            try {
                inputStream.close();
                br.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     *
     * 读取资源为Map，忽略行首为 #的注释，KV以=分隔
     *
     * @param path  基于classpath的相对路径，如"resource/xx.txt"
     * @return 资源不存在返回null
     *
     */
    public static final HashMap<String,String> readMap(String path){
        //获取资源
        Resource resource = getResource(path);
        if(resource == null){
            return null;
        }
        //获取资源的读取流
        InputStream inputStream = null;
        BufferedReader br = null;
        try{
            inputStream = resource.getInputStream();
            br = new BufferedReader(new InputStreamReader(inputStream, CharsetConstant.UTF8));
            //读取资源
            HashMap<String,String> map = new HashMap<String,String>();
            String line = StringConstant.EMPTY;
            String[] lines = null;
            while((line = br.readLine()) != null){
                line = StringUtils.trimToEmpty(line);
                if (!line.equals(StringConstant.EMPTY) && ! line.startsWith(StringConstant.HASH)) {
                    lines = line.split(StringConstant.EQUAL);
                    map.put(lines[0], lines.length > 1 ? lines[1] : null);
                }
            }
            return map;
        }catch(IOException e){
            throw new IoRuntimeException("读取资源失败：classpath:"+path, e);
        }finally{
            try {
                inputStream.close();
                br.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

}
