package cn.dolphin.core.web.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * HttpServetRequest上下文
 */
public class RequestContext {

    private static ThreadLocal<HttpServletRequest> requestLocal = new ThreadLocal<HttpServletRequest>();

    private static ThreadLocal<HttpServletResponse> responseLocal = new ThreadLocal<HttpServletResponse>();

    public static void setHttpServletRequest(HttpServletRequest request) {
        requestLocal.set(request);
    }
    /**
     * 清除request和response线程变量
     * void
     * @exception
     */
    public static void clearHttpReqResponse() {
        requestLocal.remove();
        responseLocal.remove();
    }

    public static void setHttpServletResponse(HttpServletResponse response) {
        responseLocal.set(response);
    }

    /**
     * 获取当前请求的Request，需要保证AopFilter在web.xml里配置才能取到
     *
     * @return
     */
    public static HttpServletRequest getHttpServletRequest() {
        return requestLocal.get();
    }

    /**
     * 返回response。
     * @return
     */
    public static HttpServletResponse getHttpServletResponse() {
        return responseLocal.get();
    }

}
