package cn.dolphin.core.web.util;

import cn.dolphin.core.consts.StringConstant;
import cn.dolphin.core.exception.ParamRuntimeException;
import cn.dolphin.core.regex.CoreRegex;
import cn.dolphin.core.regex.RegexUtil;
import org.apache.commons.lang3.StringUtils;


/**
 * 参数有效性验证
 *
 */
@SuppressWarnings("all")
public final class ParamValidUtil {

    /**
     * 判断参数是否有效，无效则报 illegal
     *
     * @param checks	参数有效性校验表达式(只要有一个返回true就抛参数无效异常)
     *
     */
    public static final void check(boolean ...checks){
        for (boolean check : checks) {
            if (check) {
                throw ParamRuntimeException.ILLEGAL;
            }
        }
    }

    /**
     *
     * 验证手机号是否合法(不做非空校验)
     *
     * @param mobile	11位数字
     * @return
     *
     */
    public static final boolean isMobile(String mobile) {
        return RegexUtil.matcher(mobile, CoreRegex.MOBILE);
    }

    /**
     *
     * 验证邮箱号码是否合法(不做非空校验)
     *
     * @param email	邮箱，字母数字@字母数字
     * @return
     *
     */
    public static final boolean isEmail(String email) {
        // 不能包含#
        if (email.contains(StringConstant.HASH)) {
            return false;
        }
        return RegexUtil.matcher(email, CoreRegex.EMAIL);
    }

    /**
     *
     * 校验密码格式(不做非空校验)
     *
     * @param pwd	MD5码，即32位
     * @return
     *
     */
    public static final boolean isPwd(String pwd) {
        // MD5加密一次后传递
        if (pwd.length() == 32) {
            return true;
        }
        return false;
    }

    /**
     *
     * 判断UserName是否合法(不做非空校验)
     *
     * @param userName	至少4位，字母和数字，不能是纯数字
     * @return
     *
     */
    public static final boolean isUserName(String userName) {
        // 至少4位，字母和数字，不能是纯数字
        if (userName.length() < 4 || StringUtils.isAlphanumeric(userName) || StringUtils.isNumeric(userName)) {
            return false;
        }
        return true;
    }

    /**
     *
     * 验证短信验证码是否合法(不做非空校验)
     *
     * @param smsCode	6位整数
     * @return
     *
     */
    public static final boolean isSmsCode(String smsCode) {
        return RegexUtil.matcher(smsCode, CoreRegex.SMS_CODE);
    }

    /**
     *
     * 验证图片验证码是否合法(不做非空校验)
     *
     * @param imgCode	4位整数
     * @return
     *
     */
    public static final boolean isImgCode(String imgCode) {
        return RegexUtil.matcher(imgCode, CoreRegex.IMG_CODE);
    }

    /**
     *
     * 验证邮箱验证码是否合法(不做非空校验)
     *
     * @param emailCode	6位整数
     * @return
     *
     */
    public static final boolean isEmailCode(String emailCode) {
        return RegexUtil.matcher(emailCode, CoreRegex.EMAIL_CODE);
    }

    /**
     * 验证一个月的31天
     *
     * @param value
     *            要验证的字符串
     * @return 如果是符合格式的字符串,返回 <b>true </b>,否则为 <b>false </b>
     */
    public static final boolean is31Days(String value) {
        return RegexUtil.matcher(value, CoreRegex.V_31DAYS);
    }

    /**
     * 验证是不是日期
     *
     * @param value
     *            要验证的字符串
     * @return 如果是符合格式的字符串,返回 <b>true </b>,否则为 <b>false </b>
     */
    public static final boolean Date(String value) {
        return RegexUtil.matcher(value, CoreRegex.V_DATE);
    }

    /**
     * 验证密码(数字和英文同时存在)
     *
     * @param value
     *            要验证的字符串
     * @return 如果是符合格式的字符串,返回 <b>true </b>,否则为 <b>false </b>
     */
    public static final boolean nomalStr(String value) {
        return RegexUtil.matcher(value, CoreRegex.V_PASSWORD_REG);
    }

    /**
     * 验证图片
     *
     * @param value
     *            要验证的字符串
     * @return 如果是符合格式的字符串,返回 <b>true </b>,否则为 <b>false </b>
     */
    public static final boolean Picture(String value) {
        return RegexUtil.matcher(value, CoreRegex.V_PICTURE);
    }

    /**
     * 验证压缩文件
     *
     * @param value
     *            要验证的字符串
     * @return 如果是符合格式的字符串,返回 <b>true </b>,否则为 <b>false </b>
     */
    public static final boolean Rar(String value) {
        return RegexUtil.matcher(value, CoreRegex.V_RAR);
    }

    /**
     * 验证用户注册。匹配由数字、26个英文字母或者下划线组成的字符串
     *
     * @param value
     *            要验证的字符串
     * @return 如果是符合格式的字符串,返回 <b>true </b>,否则为 <b>false </b>
     */
    public static final boolean UserName(String value) {
        return RegexUtil.matcher(value, CoreRegex.V_USERNAME);
    }


    /**
     * 判断服务文件上传时文件的contentType
     * @param FilenameExtension 文件后缀
     * @return
     */
    public static String contentType(String FilenameExtension){
        if(FilenameExtension.equals("BMP")||FilenameExtension.equals("bmp")){return "image/bmp";}
        if(FilenameExtension.equals("GIF")||FilenameExtension.equals("gif")){return "image/gif";}
        if(FilenameExtension.equals("JPEG")||FilenameExtension.equals("jpeg")||
                FilenameExtension.equals("JPG")||FilenameExtension.equals("jpg")||
                FilenameExtension.equals("PNG")||FilenameExtension.equals("png")){return "image/jpeg";}
        if(FilenameExtension.equals("HTML")||FilenameExtension.equals("html")){return "text/html";}
        if(FilenameExtension.equals("TXT")||FilenameExtension.equals("txt")){return "text/plain";}
        if(FilenameExtension.equals("VSD")||FilenameExtension.equals("vsd")){return "application/vnd.visio";}
        if(FilenameExtension.equals("PPTX")||FilenameExtension.equals("pptx")||
                FilenameExtension.equals("PPT")||FilenameExtension.equals("ppt")){return "application/vnd.ms-powerpoint";}
        if(FilenameExtension.equals("DOCX")||FilenameExtension.equals("docx")||
                FilenameExtension.equals("DOC")||FilenameExtension.equals("doc")){return "application/msword";}
        if(FilenameExtension.equals("XML")||FilenameExtension.equals("xml")){return "text/xml";}
        return "text/html";
    }

}