package cn.dolphin.core.web.util;


import cn.dolphin.core.exception.ParamRuntimeException;

/**
 * 相等比较工具
 *
 */
@SuppressWarnings("all")
public final class ParamEqualsUtil {

    /**
     * 判断desc等于src中的任意一个，如果不等于则抛异常
     *
     * @param desc
     * @param src
     *
     */
    public static final void checkEquals(String desc,String ...src){
        if (!equals(desc, src)) {
            throw ParamRuntimeException.ILLEGAL;
        }
    }

    /**
     * 判断desc等于src中的任意一个，如果不等于则抛异常
     *
     * @param desc
     * @param src
     *
     */
    public static final void checkEquals(Object desc,Object ...src){
        if (!equals(desc, src)) {
            throw ParamRuntimeException.ILLEGAL;
        }
    }

    /**
     * 目标参数等于源参数中的任意一个
     *
     * @param desc
     * @param src
     * @return
     *
     */
    public static final boolean equals(String desc,String ...src){
        if(desc == null || src==null || src.length ==0){
            return false;
        }
        for(String s : src){
            if (desc.equals(s)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 只要有一个src等于desc则返回true(不错非空校验)
     *
     * @param desc 比较的目标
     * @param src  被比较的目标集
     *
     * @return
     *
     */
    public static final boolean equals(Object desc,Object ...src){
        if(desc == null || src==null){
            return false;
        }
        for(Object s : src){
            if(desc.equals(s)) return true;
        }
        return false;
    }

}