package cn.dolphin.core.web.security.core;

import lombok.Data;

import java.util.Map;

/**
 * 用户登录信息
 */
@Data
public class IntegrationAuthentication {
    private String userId; // 账户ID
    private String loginName;//登录账户
    private String token; // 账户token
    private Integer isSuper = 0;//是否超级管理,0普通，1超级管理
    private Map<String,String[]> authParameters;

    public String getAuthParameter(String paramter){
        String[] values = this.authParameters.get(paramter);
        if(values != null && values.length > 0){
            return values[0];
        }
        return null;
    }

}
