package cn.dolphin.core.web.security.aspect;

import cn.dolphin.core.Global;
import cn.dolphin.core.id.ID;
import cn.dolphin.core.spring.SpringContextUtil;
import cn.dolphin.core.util.EmptyUtil;
import cn.dolphin.core.util.StrUtil;
import cn.dolphin.core.util.SystemClock;
import cn.dolphin.core.web.log.model.Log;
import cn.dolphin.core.web.log.service.LogService;
import cn.dolphin.core.web.security.UserSecurity;
import cn.dolphin.core.web.security.annotation.ApiLog;
import cn.dolphin.core.web.util.RequestUtil;
import cn.dolphin.ip.ipipnet.IP;
import com.alibaba.fastjson.JSONObject;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;

/**
 * 保存日志
 */
@Aspect
@Order(-1) // 保证该AOP在@Transactional之前执行
@SuppressWarnings("all")
public class LogAnnotationAspect {

    private static final Logger logger = LoggerFactory.getLogger(LogAnnotationAspect.class);

    @Around("@annotation(ds)")
    public Object logSave(ProceedingJoinPoint joinPoint, ApiLog ds) throws Throwable {

        // 请求流水号
        //String transid = getRandom();
        // 记录开始时间
        //long start = System.currentTimeMillis();
        // 获取方法参数
        String url = null;
        String httpMethod = null;
        Object result = null;
        Log log = new Log();
        log.setId(ID.getID());
        log.setCreatedAt(SystemClock.nowDate());
        if(EmptyUtil.isNotEmpty(UserSecurity.getUserId())){
            long userid = UserSecurity.getUserId();
            if ( userid >= 0l) {
                log.setUserId(userid);
            }
        }
        MethodSignature methodSignature = (MethodSignature) joinPoint.getSignature();

        ApiLog logAnnotation = methodSignature.getMethod().getDeclaredAnnotation(ApiLog.class);
        log.setSystem((null!=logAnnotation.system()&&!"".equals(logAnnotation.system())?logAnnotation.system(): Global.getConfig("spring.application.name")));
        log.setModule(logAnnotation.module());
        log.setName(logAnnotation.name());
        log.setMethod(methodSignature.getDeclaringTypeName() + "."
                + methodSignature.getName());
        // 设置操作类型
        log.setType(logAnnotation.type().getValue());

        if(logAnnotation.ip()){
            String ip = RequestUtil.getIpAddr(RequestUtil.getRequest());
            if(StrUtil.isBlank(ip)){
                ip = "未知IP";
            }
            String addrs = IP.find(ip);
            log.setIp(ip);
            log.setLocation(StrUtil.isNotBlank(addrs)?addrs:"未识别出地址");
        }
        if (logAnnotation.params()){
            List<Object> httpReqArgs = new ArrayList<Object>();
            Object[] args = joinPoint.getArgs();// 参数值
            url =  methodSignature.getDeclaringTypeName() + "/"+ methodSignature.getName();
            for (Object object : args) {
                if (object instanceof HttpServletRequest) {
                    HttpServletRequest request = (HttpServletRequest) object;
                    url = request.getRequestURI();
                    httpMethod = request.getMethod();
                } else if (object instanceof HttpServletResponse) {
                } else {

                    httpReqArgs.add(object);
                }
            }

            try {
                String params = JSONObject.toJSONString(httpReqArgs);
                log.setParams(params);
                // 打印请求参数参数
                //logger.info("开始请求，transid={},  url={} , httpMethod={}, reqData={} ", transid, url, httpMethod, params);
            } catch (Exception e) {
                logger.error("记录参数失败：{}", e.getMessage());
            }
        }




        try {
            // 调用原来的方法
            result = joinPoint.proceed();
            log.setFlag("true");
            log.setRemark("成功");
        } catch (Exception e) {
            log.setFlag("false");
            log.setRemark(e.getMessage());
            throw e;
        } finally {

            CompletableFuture.runAsync(() -> {
                try {
                    LogService logService = SpringContextUtil.getBean(LogService.class);
                    logService.saveLog(log);
                } catch (Exception e) {
                    logger.error("记录参数失败：{}", e.getMessage());
                }

            });
            // 获取回执报文及耗时
//            logger.info("请求完成, transid={}, 耗时={}, resp={}:", transid, (System.currentTimeMillis() - start),
//                    result == null ? null : JSON.toJSONString(result));

        }
        return result;
    }

    /**
     * 生成日志随机数
     *
     * @return
     */
    public String getRandom() {
        int i = 0;
        StringBuilder st = new StringBuilder();
        while (i < 5) {
            i++;
            st.append(ThreadLocalRandom.current().nextInt(10));
        }
        return st.toString() + System.currentTimeMillis();
    }

}
