package cn.dolphin.core.web.security.annotation;

import cn.dolphin.core.web.security.consts.AuthTokenConstant;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 是否开启token验证
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface ApiToken {

    String name() default AuthTokenConstant.HTTP; // 授权的形式，默认dubbo，支持 dubbo和http

    boolean value() default true; // 是否开启认证


}
