package cn.dolphin.core.web.security.annotation;

import cn.dolphin.core.web.security.enums.SysLogType;

import java.lang.annotation.*;

/**
 * 日志注解
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ApiLog {

    /**
     * 系统
     * @return
     */
    String system() default "";

    /**
     * 模块
     * @return
     */
    String module() default "";

    /**
     * 功能说明
     * @return
     */
    String name() default "";

    /**
     * 日志类型 1-登陆 2-访问 3-操作 4-异常
     *
     * @return
     */
    SysLogType type() default SysLogType.AECCESS;

    /**
     * 记录执行参数
     * @return true 记录请求参数 false 不记录
     */
    boolean params() default false;

    /**
     * 记录操作人IP
     * @return
     */
    boolean ip() default false;
}
