package cn.dolphin.core.web.security;

import cn.dolphin.core.enums.SecurityEnum;
import cn.dolphin.core.exception.ApiException;
import cn.dolphin.core.util.CastUtil;
import cn.dolphin.core.util.EmptyUtil;
import cn.dolphin.core.util.StrUtil;
import cn.dolphin.core.web.security.core.AuthenticationContext;
import cn.dolphin.core.web.security.core.IntegrationAuthentication;

/**
 * 授权异步获取用户信息
 */
public class UserSecurity {

    /**
     * 获取用户ID
     * @return
     */
    public static Long getUserId(){
        IntegrationAuthentication authentication = AuthenticationContext.get();
        if(EmptyUtil.isEmpty(authentication)){
            throw new ApiException(SecurityEnum.API_009019.code(), SecurityEnum.API_009019.msg());
            //解决登录记录日志没有用户ID问题
//            return null;
        }
        return CastUtil.castLong(authentication.getUserId(),0l);
    }

    /**
     * 获取用户ID
     * @return
     */
    public static String getUserIdStr(){
        IntegrationAuthentication authentication = AuthenticationContext.get();
        if(EmptyUtil.isEmpty(authentication)){
            throw new ApiException(SecurityEnum.API_009019.code(), SecurityEnum.API_009019.msg());
            //解决登录记录日志没有用户ID问题
//            return null;
        }
        return (StrUtil.isNotBlank(authentication.getUserId())?authentication.getUserId():"");
    }

    /**
     * 获取用户登录账号
     * @return
     */
    public static String getLoginName(){
        IntegrationAuthentication authentication = AuthenticationContext.get();
        if(EmptyUtil.isEmpty(authentication)){
            throw new ApiException(SecurityEnum.API_009019.code(), SecurityEnum.API_009019.msg());
        }
        return (StrUtil.isNotBlank(authentication.getLoginName())?authentication.getLoginName():"");

    }

    /**
     * 获取用户token
     * @return
     */
    public static String getToken(){
        IntegrationAuthentication authentication = AuthenticationContext.get();
        if(EmptyUtil.isEmpty(authentication)){
            throw new ApiException(SecurityEnum.API_009019.code(), SecurityEnum.API_009019.msg());
        }
        return (StrUtil.isNotBlank(authentication.getToken())?authentication.getToken():"");

    }

    /**
     * 验证是否是超级管理员
     * @return
     */
    public static boolean isSuperAdmin(){
        IntegrationAuthentication authentication = AuthenticationContext.get();
        if(EmptyUtil.isEmpty(authentication)){
            throw new ApiException(SecurityEnum.API_009019.code(), SecurityEnum.API_009019.msg());
        }
        if(null!=authentication.getIsSuper() && authentication.getIsSuper()==1){
            return true;
        }
        return false;
    }

}
