package cn.dolphin.core.web.log.model;

import cn.dolphin.core.bean.BaseModel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 日志实体
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Log extends BaseModel implements Serializable {

    private static final long serialVersionUID = -5398795297842978376L;

    private Long id;
    // 用户ID
    private Long userId;
    // 主机地址
    private String ip;
    // 操作地点
    private String location;
    //系统
    private String system;
    // 归属模块
    private String module;
    // 功能说明
    private String name;
    // 请求方法
    private String method;
    // 执行方法的参数值
    private String params;
    // 异常信息
    private String remark;
    // 日志类型 1-登录 2-访问 3-操作 4-异常
    private String type;
    // 是否执行成功
    private String flag;

}
