package cn.dolphin.core.web.converter;

import cn.dolphin.core.consts.StringConstant;
import cn.dolphin.core.date.DateFormatUtil;
import org.springframework.core.convert.converter.Converter;

import java.util.Date;


/**
 * Spring MVC 参数格式化 字符串转换Date
 */
public class StringToDateConverter implements Converter<String,Date>{

	public Date convert(String source) {
		return DateFormatUtil.parse(source, StringConstant.DATE_FORMAT_DATETIME);
	}
}
