package cn.dolphin.core.web.controller;


import cn.dolphin.core.map.ThreadMapUtil;
import cn.dolphin.core.page.PageBean;
import cn.dolphin.core.page.PageSupport;
import cn.dolphin.core.util.EmptyUtil;
import cn.dolphin.core.web.context.BodyCacheHttpServletRequestWrapper;
import cn.dolphin.core.web.context.RequestThreadLocal;
import cn.dolphin.core.web.context.ResponseThreadLocal;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/**
 * Controller基类
 */
@Slf4j
public abstract class BaseExtController extends GenericController{


//    protected HttpServletRequest request;
//    protected HttpServletResponse response;
    //protected HttpSession session;

    @InitBinder
    public void initBinder(ServletRequestDataBinder binder) {
        /**
         * 自动转换日期类型的字段格式
         */
        binder.registerCustomEditor(Date.class,
                new CustomDateEditor(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), true));
        binder.registerCustomEditor(Date.class, new CustomDateEditor(new SimpleDateFormat("yyyy-MM-dd HH"), true));

    }


    /**
     * @ModelAttribute方法是在调用@RequestMapping的控制器方法之前调用的
     * @param request
     * @param response
     */
    @ModelAttribute
    public void setReqAndRes(HttpServletRequest request, HttpServletResponse response){

        //使用线程隔离方式，避免覆盖
        RequestThreadLocal.setRequest(request);
        ResponseThreadLocal.setResponse(response);
        //this.request = request;
        //this.response = response;
        //this.session = request.getSession();
    }


    /**
     * 设置请求分页数据
     */
    protected PageBean getPage() {
        PageBean pageBean = PageSupport.buildPageRequest();
        return pageBean;
    }


    /**
     * 获取request
     * 线程隔离
     * @return
     */
    protected HttpServletRequest getRequest(){
        return RequestThreadLocal.getRequest();
    }

    /**
     * 获取response
     * 线程隔离
     * @return
     */
    protected HttpServletResponse getResponse(){
        return ResponseThreadLocal.getResponse();
    }

    /**
     * 获取传递json取值map兼容正常取值
     * @return
     */
    protected Map<String,Object> getRequestParamsMap(){
        try {
            if(EmptyUtil.isEmpty(ThreadMapUtil.get())){
                return ThreadMapUtil.get();
            }else {
                ThreadMapUtil.put(BodyCacheHttpServletRequestWrapper.getParamsMap(getRequest()));
                return (EmptyUtil.isNotEmpty(ThreadMapUtil.get())?ThreadMapUtil.get():null);
            }
        }catch (Exception e){
            return null;
        }
    }

    /**
     * redirect跳转
     *
     * @param url 目标url
     */
    protected String redirect(String url) {
        return new StringBuilder("redirect:").append(url).toString();
    }

    /**
     * 输出json数据字符串
     *
     * @param response
     *            HttpServletResponse对象
     * @param jsonDataStr
     *            字符串
     */
    protected void outJson(HttpServletResponse response, Object jsonDataStr) {
        try {
            response.setContentType("application/json;charset=utf-8");
            PrintWriter out = response.getWriter();
            out.print(jsonDataStr);
            out.flush();
            out.close();
        } catch (IOException e) {
            log.error("输出json数据字符串",e);
        }
    }







}
