package cn.dolphin.core.util;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;

import java.util.UUID;

/**
 * UUID工具类
 */
public class UUIDUtil {

    private static String[] chars = new String[] { "a", "b", "c", "d", "e", "f",
            "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s",
            "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5",
            "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I",
            "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V",
            "W", "X", "Y", "Z" };

    /**
     * 8位UUID
     *
     * @return
     */
    public static String getUUID8() {
        return getUUID(8, UUID.randomUUID());
    }

    /**
     * 8位UUID
     *
     * @return
     */
    public static String getUUID8(byte[] bytes) {
        return getUUID(8, UUID.nameUUIDFromBytes(bytes));
    }

    /**
     * 8位UUID
     *
     * @return
     */
    public static String getUUID8(String fromString) {
        return getUUID(8, UUID.fromString(fromString));
    }

    /**
     * 获取9位纯数字id
     * @return
     */
    public static long getUID19(){
        long uid = 0l;
        String dateuid = ""+(int)((Math.random()*9+1)*10000000);
        uid = Long.parseLong(dateuid);
        return uid;
    }


    /**
     * 16位UUID
     *
     * @return
     */
    public static String getUUID16() {
        return getUUID(16, UUID.randomUUID());
    }

    /**
     * 16位UUID
     *
     * @return
     */
    public static String getUUID16Num(){
        int machineId = 1;//最大支持1-9个集群机器部署
        int hashCodeV = UUID.randomUUID().toString().hashCode();
        if(hashCodeV < 0) {//有可能是负数
            hashCodeV = - hashCodeV;
        }
        // 0 代表前面补充0
        // 4 代表长度为4
        // d 代表参数为正数型
        return machineId + String.format("%015d", hashCodeV);
    }

    /**
     * 16位UUID
     *
     * @return
     */
    public static String getUUID16(String fromString) {
        return getUUID(16, UUID.fromString(fromString));
    }

    /**
     * 16位UUID
     *
     * @return
     */
    public static String getUUID16(byte[] bytes) {
        return getUUID(16, UUID.nameUUIDFromBytes(bytes));
    }

    /**
     * 生成32位的UUID
     *
     * @return String
     */
    public static String getUUID32() {
        return UUID.randomUUID().toString().replace("-", "");
    }


    /**
     * 顺序的32位UUID
     * @return
     */
    public static String generatorUUID(){
        TimeBasedGenerator timeBasedGenerator = Generators.timeBasedGenerator(EthernetAddress.fromInterface());
        return timeBasedGenerator.generate().toString().replace("-","");
    }

    public static String generateShortUuid() {
        StringBuffer shortBuffer = new StringBuffer();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < 8; i++) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(chars[x % 0x3E]);
        }
        return shortBuffer.toString();

    }

    /**
     * 生成指定长度的uuid
     */
    private static String getUUID(int length, UUID uuid) {
        int groupLength = 32 / length;
        StringBuilder sb = new StringBuilder();
        String id = uuid.toString().replace("-", "");
        for (int i = 0; i < length; i++) {
            String str = id.substring(i * groupLength, i * groupLength + groupLength);
            int x = Integer.parseInt(str, 16);
            sb.append(chars[x % 0x3E]);
        }
        return sb.toString();
    }

    /**
     * 生成指定长度的uuid
     */
    private static String getUUID(int length) {
        int groupLength = 32 / length;
        StringBuilder sb = new StringBuilder();
        String id = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < length; i++) {
            String str = id.substring(i * groupLength, i * groupLength + groupLength);
            int x = Integer.parseInt(str, 16);
            sb.append(chars[x % 0x3E]);
        }
        return sb.toString();
    }

}
