package cn.dolphin.core.util;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 用ThreadLocal来存储Session,以便实现Session any where.
 *
 */
public class SessionLocalUtil {

    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    private static ThreadLocal<HttpSession> httpSessionThreadLocal = new ThreadLocal<HttpSession>();

    public static HttpSession getHttpSessionThreadLocal() {
        return SessionLocalUtil.httpSessionThreadLocal.get();
    }

    public static void setHttpSessionThreadLocal(HttpSession httpSession) {
        SessionLocalUtil.httpSessionThreadLocal.set(httpSession);
    }

    public static void remove() {
        SessionLocalUtil.httpSessionThreadLocal.remove();
    }
}
