package cn.dolphin.core.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 1.专门用来分配序列号
 * 2.本地消息的唯一msgId键值
 */
@SuppressWarnings("all")
public class SequenceNumberUtil {

    private volatile short mSquence = 0;

    private volatile long preMsgId = 0;

    private static SequenceNumberUtil maker = new SequenceNumberUtil();

    private SequenceNumberUtil() {
    }

    public static SequenceNumberUtil getInstance() {
        return maker;
    }

    public short make() {
        synchronized (this) {
            mSquence++;
            if (mSquence >= Short.MAX_VALUE)
                mSquence = 1;
        }
        return mSquence;
    }

    /**依旧比较 Ugly 的解决办法
     * 多线程情况下，生成相同的msgId
     * */
    public int makelocalUniqueMsgId(){
        synchronized(SequenceNumberUtil.this) {
            int timeStamp = (int) (System.currentTimeMillis() % 10000000);
            int localId = timeStamp + 90000000;
            //logger.e("#yingmu2#之前的msgId:%d",preMsgId);
            if (localId == preMsgId) {
                localId++;
                if (localId >= 100000000) {
                    localId = 90000000;
                }
            }
            preMsgId = localId;
            return localId;
        }
    }

    /**比较 Ugly 的解决办法,但是比较实用*/
    public boolean isFailure(int msgId){
        if(msgId>=90000000){
            return true;
        }
        return false;
    }

    private  final long DEFAULT_COUNTER = 100;
    private  final String FOMATE = "000";
    private  long counter;
    private  String lastDate;

    /**
     * 生成唯一有序编号(带前缀)
     *
     * @return
     */
    public  synchronized String generate(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        String date = new SimpleDateFormat("yyMMddHHmmss").format(new Date());
        if (lastDate == null || !lastDate.equals(date)) {
            lastDate = date;
            counter = DEFAULT_COUNTER;
        }
        return prefix + date + new DecimalFormat(FOMATE).format(counter++);
    }

    /**
     * 生成唯一有序编号(不带前缀)
     *
     * @return
     */
    public  synchronized String generate() {
        return generate("");
    }

//    public static void main(String[] args) {
//        System.out.println(SequenceNumberUtil.getInstance().makelocalUniqueMsgId());
//        System.out.println(SequenceNumberUtil.getInstance().makelocalUniqueMsgId());
//
//    }

    public static void main(String[] args) throws InterruptedException {
        Runnable tast = new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i < 100; i++) {
                    System.out.println(SequenceNumberUtil.getInstance().generate());
                }
            }
        };

        Thread t1 = new Thread(tast);
        Thread t2 = new Thread(tast);
        Thread t3 = new Thread(tast);

        t1.start();
        t2.start();
        Thread.sleep(1000);
        t3.start();
    }
}
