package cn.dolphin.core.util;

import java.util.Random;
import java.util.UUID;

/**
 * 随机工具类
 *
 */
public final class RandomUtil {

    private static final Random RANDOM = new Random();

    // 定义验证码字符.去除了O、I、l、、等容易混淆的字母
    public static final char authCodeAll[] = {
            'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y',
            'a', 'c', 'd', 'e', 'f', 'h', 'k', 'm', 'n', 'p', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y',
            '3', '4', '5', '7', '8' };

    // 定义验证码数字
    public static final char authCodeNumber[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' };

    /**
     * 生成字母和数字验证码
     */
    public static String anCode(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; i++) {
            sb.append(authCodeAll[number(0, length)]);
        }
        return sb.toString();
    }

    /**
     * 生成纯数字验证码
     */
    public static String numCode(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; i++) {
            sb.append(authCodeNumber[number(0, length)]);
        }
        return sb.toString();
    }

    /**
     * 短信验证码
     * @return
     */
    public static int smsCode(){
        int code = (int)((Math.random()*9+1)*100000);
        return code;
    }

    /**
     * 产生两个数之间的随机数
     *
     * @param min 最小数（包括）
     * @param max 最大数（不包括）
     */
    public static int number(int min, int max) {
        if (min == max) {
            return min;
        }
        return min + RANDOM.nextInt(max - min);
    }

    /**
     * 产生0--number的随机数,不包括number
     *
     * @param number   	数字
     * @return int 		随机数字
     */
    public static int number(int number) {
        if (number == 0) {
            return 0;
        }
        return RANDOM.nextInt(number);
    }

    /**
     * 生成RGB随机数
     */
    public static int[] getRandomRgb() {
        int[] rgb = new int[3];
        for (int i = 0; i < 3; i++) {
            rgb[i] = RANDOM.nextInt(255);
        }
        return rgb;
    }

    /**
     *
     * 随机生成6位数字字符串
     *
     * @return String
     */
    public static String randomGenerate6() {
        Long temp = Math.round(Math.random()*1000000);
        while(temp<100000){
            temp = Math.round(Math.random()*1000000);
        }
        return String.valueOf(temp);
    }

    /***
     * 根据UUID作为引子的随机数字符串
     *
     * @param len
     * @return
     */
    public static String getRandomUuidStr(int len) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random(UUID.randomUUID().hashCode());
        for (int i = 0; i < len; i++) {
            sb.append(random.nextInt(9));
        }

        return sb.toString();
    }


    /**
     * 生成规则设备编号:设备类型+五位编号（从1开始，不够前补0）
     *
     * @param equipmentType
     *              设备类型
     * @param equipmentNo
     *              最新设备编号
     * @return
     */
    public static String getNewEquipmentNo(String equipmentType, String equipmentNo){
        String newEquipmentNo = "00001";

        if(equipmentNo != null && !equipmentNo.isEmpty()){
            int newEquipment = Integer.parseInt(equipmentNo) + 1;
            newEquipmentNo = String.format(equipmentType + "%05d", newEquipment);
        }

        return newEquipmentNo;
    }


    public static void main(String[] args) {
        System.out.println(RandomUtil.getRandomUuidStr(5));
        String equipmentNo = RandomUtil.getNewEquipmentNo("GW", "00001");
        System.out.println("生成设备编号：" + equipmentNo);
    }

}
