package cn.dolphin.core.util;

import cn.dolphin.core.date.TimeUtil;

import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;

/**
 * 编号规则工具
 */
public class NoUtil {

    /**
     * 根据当前日期和5为随机数生成唯一编号(生成的长度为18位数字)
     * @return
     */
    public static String timeRandom() {
        return timeRandom(null);
    }

    /**
     * 根据日期和5为随机数生成唯一编号(生成的长度为18位数字)
     * @param date
     * @return
     */
    public static String timeRandom(Date date) {
        int numLen = 5;
        if(date == null) {
            date = TimeUtil.getTime();
        }
        long time = date.getTime();
        int num = (int)(100000 * ThreadLocalRandom.current().nextDouble());
        String random = String.valueOf(num);
        int rLen = random.length();
        if(rLen < numLen) {
            for (int i = 0; i < numLen - rLen; i++) {
                int cldNum = (int)(10 * ThreadLocalRandom.current().nextDouble());
                random = random + cldNum;
            }
        }
        String no = String.valueOf(time) + random;
        return no;
    }

    public static void main(String[] args) {
        System.out.println(NoUtil.timeRandom());
    }
}
