package cn.dolphin.core.util;

import cn.dolphin.core.consts.StringConstant;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.helper.StringUtil;


/**
 * 名称工具
 */
public final class NameUtil {

    /**
     * 展示手机号时的模糊处理占位符
     */
    private static final String MOBILE_DIM = "****";
    /**
     * 展示邮箱时的模糊处理占位符
     */
    private static final String EMAIL_DIM = "****";
    /**
     * 展示QQ时的模糊处理占位符
     */
    private static final String QQ_DIM = "****";
    /**
     * 展示身份证号时的模糊处理占位符
     */
    private static final String IDCARD_DIM = "****************";
    /**
     * 展示银行卡号时的模糊处理占位符
     */
    private static final String BANKCARD_DIM = "********";

    /**
     * 将Mobile模糊处理
     *
     * @param mobile
     * @return
     *
     */
    public static String mobileDim(String mobile){
        return mobile.substring(0, 3) + MOBILE_DIM + mobile.substring(mobile.length() - 4);
    }

    /**
     * 将邮箱模糊处理
     *
     * @param email
     * @return
     *
     */
    public static String emailDim(String email){
        String[] parts = email.split(StringConstant.AT);
        return parts[0].substring(0, 1) + EMAIL_DIM + parts[0].substring(parts[0].length() - 1) + StringConstant.AT + parts[1];
    }

    /**
     * 将QQ模糊处理
     *
     * @param qq
     * @return
     *
     */
    public static String qqDim(String qq){
        return qq.substring(0, 2) + QQ_DIM + qq.substring(qq.length() - 2);
    }

    /**
     * 将身份证模糊处理
     *
     * @param idcard
     * @return
     *
     */
    public static String idcardDim(String idcard){
        if (StringUtils.isBlank(idcard)) {
            return StringConstant.EMPTY;
        }
        return idcard.substring(0, 1) + IDCARD_DIM + idcard.substring(idcard.length() - 1);
    }

    /**
     * 将银行卡模糊处理
     *
     * @param bankCard
     * @return
     *
     */
    public static String bankCardDim(String bankCard){
        return bankCard.substring(0, 4) + BANKCARD_DIM + bankCard.substring(bankCard.length() - 3);
    }

    /**
     * 转换成骆驼命名法返回
     *
     * @param name
     * @return
     */
    public static String getCamelName(String name) {
        if (StringUtil.isBlank(name)) {
            return null;
        }
        name = name.toLowerCase();
        //去掉前面的_
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        //去掉后面的_
        while (name.endsWith("_")) {
            name = name.substring(0, name.length() - 1);
        }

        StringBuilder sb = new StringBuilder();

        for (int i = 0; i < name.length(); i++) {

            char c = name.charAt(i);

            if (c == '_') {
                i++;
                sb.append(Character.toUpperCase(name.charAt(i)));
                continue;
            }
            sb.append(c);
        }

        return sb.toString();
    }

    /**
     * 将骆驼命名法反转成下划线返回
     *
     * @param name
     * @return
     */
    public static String getUnderlineName(String name) {
        if (StringUtil.isBlank(name)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); i++) {
            char c = name.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                sb.append("_");
            }
            sb.append(c);
        }
        return sb.toString().toLowerCase();
    }

    /**
     * 首字母大写
     *
     * @param name
     * @return
     */
    public static String getFirstUpperName(String name) {
        if (StringUtil.isBlank(name)) {
            return null;
        }
        String firstChar = name.substring(0, 1).toUpperCase();
        return firstChar + name.substring(1);
    }

    /**
     * 首字母小写
     *
     * @param name
     * @return
     */
    public static String getFirstLowerName(String name) {
        if (StringUtil.isBlank(name)) {
            return null;
        }
        String firstChar = name.substring(0, 1).toLowerCase();
        return firstChar + name.substring(1);
    }

    /**
     * 保留原文件后缀生成唯一文件名
     *
     * @param fileName
     * @return
     */
    public static String createUniqueFileName(String fileName) {

        int    index  = fileName.lastIndexOf(".");
        String suffix = fileName.substring(index);
        String uqName = UUIDUtil.getUUID16() + suffix;
        return uqName;
    }

    /**
     * 在文件名后加上指定后缀，不包括后缀名
     *
     * @param fileName
     * @param endSuffix
     * @return
     */
    public static String createEndSuffixFileName(String fileName, String endSuffix) {
        int    index       = fileName.lastIndexOf(".");
        String preFileName = fileName.substring(0, index);
        String suffix      = fileName.substring(index);
        return preFileName + endSuffix + suffix;
    }



}
