package cn.dolphin.core.util;

/**
 * 数学计算工具
 *
 */
public final class MathUtil {

    /**
     * 除：有余数时进1
     *
     * @param x
     * @param y
     * @return
     *
     */
    public static int ceilDiv(int x, int y) {
        if (x % y > 0) {
            return x / y + 1;
        } else {
            return x / y;
        }
    }

    /**
     * 除：有余数时进1
     *
     * @param x
     * @param y
     * @return
     *
     */
    public static long ceilDiv(long x, long y) {
        if (x % y > 0) {
            return x / y + 1;
        } else {
            return x / y;
        }
    }

    /**
     * 除：有余数时进1
     *
     * @param x
     * @param y
     * @return
     *
     */
    public static long ceilDiv(long x, int y) {
        if (x % y > 0) {
            return x / y + 1;
        } else {
            return x / y;
        }
    }

    /**
     * 除：有余数时进1
     *
     * @param x
     * @param y
     * @return
     *
     */
    public static long ceilDiv(int x, long y) {
        if (x % y > 0) {
            return x / y + 1;
        } else {
            return x / y;
        }
    }

    /**
     * 使用位运算实现加减乘除
     */

    /**
     * 使用位运算实现加法 a+b=?
     * 1 二进制的加法运算考虑 0+0，0+1，1+1 使用异或运算得到该位的计算结果，但是没有进位，此时结果时未进位的 xor
     * 2 当计算二级制 1+1 时，需要进位，与运算能够知道哪个地方发生了进位，左移1步，即可完成进位,结果为 temp
     * 3 所以计算的逻辑 a + b = xor + temp ;当temp 为0时 a+b= xor ;temp不为0时，则将a=xor,b=temp 重复1，2 步骤；
     *
     * @param a
     * @param b
     * @return
     */
    public static int add(int a, int b) {
        int xor = a ^ b;
        int temp = (a & b) << 1;
        if (temp == 0) {
            return xor;
        } else {
            return add(xor, temp);
        }
    }


    /**
     * 位操作实现减法
     * 1 ~n=-(n+1)，比如：~3=-4
     * 2 减法转换为加法运算
     *
     * @param a
     * @param b
     * @return
     */
    public static int minus(int a, int b) {
        int minus = ~(b - 1);
        return add(a, minus);
    }


    /**
     * 位操作实现乘法
     * 二进制和十进制思维方式都是 a * b 代表 b个a相加；
     *
     * @param a
     * @param b
     * @return
     */
    public static int multi(int a, int b) {
        int sum = 0;
        int index = 0;
        while (b != 0) {
            if ((b & 1) == 1) {
                sum = add(sum, a << index);
            }
            b = b >> 1;
            index = add(index, 1);
        }
        return sum;
    }

    /**
     * 位操作实现除法
     * 除法的思维是乘法的思维正好相反，求两个数相除的结果就是求被除数可以减去多个除数，最后考虑符号位正负即可；
     * 1 确定 a b 相除结果的符号位，取符号位的异或结果作为商的符号位
     * 2 计算可以相减的次数
     *
     * @param a
     * @param b
     * @return
     */
    public static int sub(int a, int b) {
        int xor = a ^ b;
        a = (a < 0) ? -a : a;
        b = (b < 0) ? -b : b;
        if (b == 0) {
            throw new IllegalArgumentException("除数不能为0");
        }
        int minus = 0;
        int index = -1;
        while (minus >= 0) {
            a = minus = minus(a, b);
            index = add(index, 1);
        }
        if (xor > 0) {
            return index;
        }
        return -index;
    }
}
