package cn.dolphin.core.util;

/**
 * Long工具
 */
@SuppressWarnings("all")
public final class LongUtil {

    // 64进制(62进制出错率高，所以额外增加 _- 两个字符)
    private final static char[] CHAR64 = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-"
            .toCharArray();

    /**
     * null转0
     *
     * @param o
     * @return
     *
     */
    public static final Long toEmpty(Long o) {
        return o == null ? 0 : o;
    }

    /**
     * 转换字符串为Long
     *
     * @param num
     * @return 如果字符串为空则返回null，如果字符串非数值则异常
     */
    public static final Long valueOf(String num) {
        // 如果为空，返回null
        if (StrUtil.isBlank(num)) {
            return null;
        }
        // 非空转换，格式错误抛异常
        return Long.valueOf(num.trim());
    }

    /**
     * 转换字符串为Long
     *
     * @param num
     * @return 如果字符串为空则返回0，如果字符串非数值则异常
     */
    public static final Long valueOfZero(String num) {
        // 如果为空，返回0
        if (StrUtil.isBlank(num)) {
            return 0L;
        }
        // 非空转换，格式错误抛异常
        return Long.valueOf(num.trim());
    }

    /**
     *
     * 转换为Integer
     *
     * @param l
     * @return
     *
     */
    public final static Integer toInt(Long l) {
        if (l == null)
            return null;
        return l.intValue();
    }

    /**
     * 将数字转换为62进制
     *
     * @param num
     * @return
     *
     */
    public static final String to64(Long num) {
        char[] buf = new char[64];
        int charPos = 64;
        int radix = 1 << 6;
        long mask = radix - 1;
        do {
            buf[--charPos] = CHAR64[(int) (num & mask)];
            num >>>= 6;
        } while (num != 0);
        return new String(buf, charPos, (64 - charPos));
    }

    /**
     * 将62进制转换为数字
     *
     * @param str
     * @return
     *
     */
    public static final Long parse64(String str) {
        long result = 0;
        for (int i = str.length() - 1; i >= 0; i--) {
            for (int j = 0; j < CHAR64.length; j++) {
                if (str.charAt(i) == CHAR64[j]) {
                    result += ((long) j) << 6 * (str.length() - 1 - i);
                }
            }
        }
        return result;
    }

}
