package cn.dolphin.core.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Objects;
import java.util.function.Supplier;

/**
 * 日志管理类
 * 后续,所有的日志打印都需要使用这个工具类
 */
public class LogUtil {

    private LogUtil(){}

    public static Logger logger;

    public static Logger getInstance(){
        if (logger == null){
            synchronized (LogUtil.class){
                logger = LoggerFactory.getLogger(LogUtil.class);
            }
        }
        return logger;
    }

    /**
     * 进入方法打印日志
     * @param clazz
     * @return
     */
    public static String intoMethod(Class clazz){
        String classStr = clazz.getSimpleName();  //获取类名
        StackTraceElement[] stacks = new Throwable().getStackTrace();  //运行数组
        String methodStr = stacks[1].getMethodName();  //获取运行的方法名

        //返回拼接字符串
        return "=============go into "+classStr+"::"+methodStr;
    }

    /**
     * 出方法打印日志
     * @param clazz
     * @return
     */
    public static String outMethod(Class clazz){
        String classStr = clazz.getSimpleName();  //获取类名
        StackTraceElement[] stacks = new Throwable().getStackTrace();  //运行数组
        String methodStr = stacks[1].getMethodName();  //获取运行的方法名

        //返回拼接字符串
        return "=============go out "+classStr+"::"+methodStr;
    }


    public static void debug(Logger logger, String format, Supplier<Object> supplier) {
        if (logger.isDebugEnabled()) {
            logger.debug(format, supplier.get());
        }
    }
    public static void debug(Logger logger, String format, Supplier<Object> ...suppliers) {
        if (logger.isDebugEnabled()) {
            Object[] params = transferParams(suppliers);
            logger.debug(format, params);
        }
    }
    public static void debug(Logger logger, String format, Object message) {
        if (logger.isDebugEnabled()) {
            logger.debug(format, message);
        }
    }
    public static void debug(Logger logger, String format, Object ...message) {
        if (logger.isDebugEnabled()) {
            logger.debug(format, message);
        }
    }
    public static void debug(Logger logger, Supplier<Object> supplier) {
        if (logger.isDebugEnabled()) {
            logger.debug(Objects.toString(supplier.get()));
        }
    }
    public static void debug(Logger logger, Object message) {
        if (logger.isDebugEnabled()) {
            logger.debug(Objects.toString(message));
        }
    }
    public static void info(Logger logger, String format, Supplier<Object> supplier) {
        if (logger.isInfoEnabled()) {
            logger.info(format, supplier.get());
        }
    }
    public static void info(Logger logger, String format, Supplier<Object> ...suppliers) {
        if (logger.isDebugEnabled()) {
            Object[] params = transferParams(suppliers);
            logger.debug(format, params);
        }
    }
    public static void info(Logger logger, String format, Object message) {
        if (logger.isInfoEnabled()) {
            logger.info(format, message);
        }
    }
    public static void info(Logger logger, String format, Object ...message) {
        if (logger.isInfoEnabled()) {
            logger.info(format, message);
        }
    }
    public static void info(Logger logger, Supplier<Object> supplier) {
        if (logger.isInfoEnabled()) {
            logger.info(Objects.toString(supplier.get()));
        }
    }
    public static void info(Logger logger, Object message) {
        if (logger.isInfoEnabled()) {
            logger.info(Objects.toString(message));
        }
    }
    public static void error(Logger logger, String format, Supplier<Object> supplier) {
        if (logger.isErrorEnabled()) {
            logger.error(format, supplier.get());
        }
    }
    public static void error(Logger logger, String format, Supplier<Object> ...suppliers) {
        if (logger.isDebugEnabled()) {
            Object[] params = transferParams(suppliers);
            logger.debug(format, params);
        }
    }
    public static void error(Logger logger, String format, Object message) {
        if (logger.isErrorEnabled()) {
            logger.error(format, message);
        }
    }
    public static void error(Logger logger, String format, Object ...message) {
        if (logger.isErrorEnabled()) {
            logger.error(format, message);
        }
    }
    public static void error(Logger logger, Supplier<Object> supplier) {
        if (logger.isErrorEnabled()) {
            logger.error(Objects.toString(supplier.get()));
        }
    }
    public static void error(Logger logger, Object message) {
        if (logger.isErrorEnabled()) {
            logger.error(Objects.toString(message));
        }
    }
    public static void warn(Logger logger, String format, Supplier<Object> supplier) {
        if (logger.isWarnEnabled()) {
            logger.warn(format, supplier.get());
        }
    }
    public static void warn(Logger logger, String format, Object message) {
        if (logger.isWarnEnabled()) {
            logger.warn(format, message);
        }
    }
    public static void warn(Logger logger, Supplier<Object> supplier) {
        if (logger.isWarnEnabled()) {
            logger.warn(Objects.toString(supplier.get()));
        }
    }
    public static void warn(Logger logger, Object message) {
        if (logger.isWarnEnabled()) {
            logger.warn(Objects.toString(message));
        }
    }

    /*****-----****/
    public static void debug(String format, Supplier<Object> supplier) {
        if (logger.isDebugEnabled()) {
            logger.debug(format, supplier.get());
        }
    }
    public static void debug(String format, Supplier<Object> ...suppliers) {
        if (logger.isDebugEnabled()) {
            Object[] params = transferParams(suppliers);
            logger.debug(format, params);
        }
    }
    public static void debug(String format, Object message) {
        if (logger.isDebugEnabled()) {
            logger.debug(format, message);
        }
    }
    public static void debug(String format, Object ...message) {
        if (logger.isDebugEnabled()) {
            logger.debug(format, message);
        }
    }
    public static void debug(Supplier<Object> supplier) {
        if (logger.isDebugEnabled()) {
            logger.debug(Objects.toString(supplier.get()));
        }
    }
    public static void debug(Object message) {
        if (logger.isDebugEnabled()) {
            logger.debug(Objects.toString(message));
        }
    }
    public static void info(String format, Supplier<Object> supplier) {
        if (logger.isInfoEnabled()) {
            logger.info(format, supplier.get());
        }
    }
    public static void info(String format, Supplier<Object> ...suppliers) {
        if (logger.isDebugEnabled()) {
            Object[] params = transferParams(suppliers);
            logger.debug(format, params);
        }
    }
    public static void info(String format, Object message) {
        if (logger.isInfoEnabled()) {
            logger.info(format, message);
        }
    }
    public static void info(String format, Object ...message) {
        if (logger.isInfoEnabled()) {
            logger.info(format, message);
        }
    }
    public static void info(Supplier<Object> supplier) {
        if (logger.isInfoEnabled()) {
            logger.info(Objects.toString(supplier.get()));
        }
    }
    public static void info(Object message) {
        if (logger.isInfoEnabled()) {
            logger.info(Objects.toString(message));
        }
    }
    public static void error(String format, Supplier<Object> supplier) {
        if (logger.isErrorEnabled()) {
            logger.error(format, supplier.get());
        }
    }
    public static void error(String format, Supplier<Object> ...suppliers) {
        if (logger.isDebugEnabled()) {
            Object[] params = transferParams(suppliers);
            logger.debug(format, params);
        }
    }
    public static void error(String format, Object message) {
        if (logger.isErrorEnabled()) {
            logger.error(format, message);
        }
    }
    public static void error(String format, Object ...message) {
        if (logger.isErrorEnabled()) {
            logger.error(format, message);
        }
    }
    public static void error(Supplier<Object> supplier) {
        if (logger.isErrorEnabled()) {
            logger.error(Objects.toString(supplier.get()));
        }
    }
    public static void error(Object message) {
        if (logger.isErrorEnabled()) {
            logger.error(Objects.toString(message));
        }
    }
    public static void warn(String format, Supplier<Object> supplier) {
        if (logger.isWarnEnabled()) {
            logger.warn(format, supplier.get());
        }
    }
    public static void warn(String format, Object message) {
        if (logger.isWarnEnabled()) {
            logger.warn(format, message);
        }
    }
    public static void warn(Supplier<Object> supplier) {
        if (logger.isWarnEnabled()) {
            logger.warn(Objects.toString(supplier.get()));
        }
    }
    public static void warn(Object message) {
        if (logger.isWarnEnabled()) {
            logger.warn(Objects.toString(message));
        }
    }

    private static Object[] transferParams(Supplier<Object>[] suppliers) {
        Object[] params = new Object[suppliers.length];
        for ( int i=0,length=suppliers.length;i<length;i++ ) {
            params[i] = suppliers[i];
        }
        return params;
    }

    public static void main(String[] args) {
        System.out.println(intoMethod(LogUtil.class));
        LogUtil.getInstance().info("ssss");
    }

}
