package cn.dolphin.core.util;

import com.google.common.base.Function;
import com.google.common.collect.Maps;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;


/**
 * list工具类
 */
@SuppressWarnings("all")
public class ListUtil {

    private static Pattern kk = Pattern.compile("(\\{[^\\}]*\\})");

    /**
     * 抽取字符串中{}括号之内的内容，返回List的数组
     * @param msg
     * @return
     */
    public static List<String> extractMessageByRegular(String msg){
        List<String> list=new ArrayList<String>();
        Matcher m = kk.matcher(msg);
        while(m.find()){
            list.add(m.group().substring(1, m.group().length()-1));
        }
        return list;
    }

    /*
     * 排序算法的分类如下： 1.插入排序（直接插入排序、折半插入排序、希尔排序）； 2.交换排序（冒泡排序、快速排序）；
     * 3.选择排序（直接选择排序、堆排序）； 4.归并排序； 5.分配排序（基数排序）。
     *
     * 关于排序方法的选择： (1)若n较小(如n≤50)，可采用直接插入或直接选择排序。
     * (2)若文件初始状态基本有序(指正序)，则应选用直接插人、冒泡或随机的快速排序为宜；
     * (3)若n较大，则应采用时间复杂度为O(nlgn)的排序方法：快速排序、堆排序或归并排序。
     */

    public static boolean isEmpty(List list) {
        return (list == null) || (list.size() == 0);
    }

    public static boolean isNotEmpty(List list) {
        return (list != null) && (list.size() != 0);
    }

    /**
     * 去掉重复的
     * @param list
     * @return
     */
    public static List distinct(List list) {
        Set set = new HashSet();
        List newList = new ArrayList();
        for (Iterator iter = list.iterator(); iter.hasNext();) {
            Object element = iter.next();
            if (set.add(element))
                newList.add(element);
        }
        return newList;
    }

    public static List<String> toStringList(List list) {
        List<String> newList = new ArrayList<String>(list.size());
        if (isEmpty(list))
            return newList;
        for (int i = 0; i < list.size(); i++) {
            newList.add(i,String.valueOf(list.get(i)));
        }
        return newList;
    }

    public static List<Integer> toIntList(List list) {
        List<Integer> newList = new ArrayList<Integer>(list.size());
        if (isEmpty(list))
            return newList;
        for (int i = 0; i < list.size(); i++) {
            newList.add(i,(int)list.get(i));
        }
        return newList;
    }

    /**
     * 转 int 集合,[false:0,true:1]
     *
     * @param list
     * @return
     */
    public static List<Integer> toIntListByBoolean(List<Boolean> list) {
        List<Integer> newList = new ArrayList<Integer>(list.size());
        if (isEmpty(list))
            return newList;
        for (int i = 0; i < list.size(); i++) {
            if (list.get(i) == false) {
                newList.add(i,0);
            } else {
                newList.add(i,1);
            }
        }
        return newList;
    }

    public static List<Double> toDoubleList(List list) {
        List<Double> newList = new ArrayList<Double>(list.size());
        if (isEmpty(list))
            return newList;
        for (int i = 0; i < list.size(); i++) {
            newList.add(i,(double)list.get(i));
        }
        return newList;
    }

    public static List<Float> toFloatList(List list) {
        List<Float> newList = new ArrayList<Float>(list.size());
        if (isEmpty(list))
            return newList;
        for (int i = 0; i < list.size(); i++) {
            newList.add(i,(float)list.get(i));
        }
        return newList;
    }

    public static List<Long> toLongList(List list) {
        List<Long> newList = new ArrayList<Long>(list.size());
        if (isEmpty(list))
            return newList;
        for (int i = 0; i < list.size(); i++) {
            newList.add(i,(long)list.get(i));
        }
        return newList;
    }

    public static List<Short> toShortList(List list) {
        List<Short> newList = new ArrayList<Short>(list.size());
        if (isEmpty(list))
            return newList;
        for (int i = 0; i < list.size(); i++) {
            newList.add(i,(short)list.get(i));
        }
        return newList;
    }

    public static List<Byte> toByteList(List list) {
        List<Byte> newList = new ArrayList<Byte>(list.size());
        if (isEmpty(list))
            return newList;
        for (int i = 0; i < list.size(); i++) {
            newList.add(i,(byte)list.get(i));
        }
        return newList;
    }

    /**
     * 将集合转为字符串，逗号分隔，如 [1,2,3]
     *
     * @param list
     * @return
     */
    public static String join(List list) {
        if (isEmpty(list))
            return "";
        if (list.size() == 1)
            return "[" + String.valueOf(list.get(0)) + "]";

        StringBuffer result = new StringBuffer("[");

        for (int i = 0; i < list.size(); i++) {
            if (i == list.size() - 1) {
                result.append(list.get(i) + "]");
            } else {
                result.append(list.get(i) + ",");
            }
        }
        return result.toString();
    }

    /**
     * 将集合转为字符串,并以某个字符相连，如 1#2#3
     *
     * @param list
     * @param splitStr
     * @return
     */
    public static String join(List list, String splitStr) {
        if (list == null || list.size() == 0)
            return "";
        if (list.size() == 1){
            return String.valueOf(list.get(0));
        }

        StringBuffer result = new StringBuffer("");

        for (int i = 0; i < list.size(); i++) {
            if (i == list.size() - 1) {
                result.append(list.get(i));
            } else {
                result.append(list.get(i) + splitStr);
            }
        }
        return result.toString();
    }

    /**
     * 随机打乱一个集合
     *
     * @param list
     * @return
     */
    public static List shuffle(List list) {
        Collections.shuffle(list);
        return list;
    }

    /**
     * 集合转SET
     *
     * @param list
     *            an list of T objects.
     * @param <T>
     *            a T object.
     * @return a {@link Set} object.
     */
    public static final <T> Set<T> toSet(List<T> list) {
        if (isEmpty(list)) {
            return null;
        }
        return new LinkedHashSet<T>(list);
    }

    /**
     * 将一个大的list拆分成多个小list
     *
     * @param list
     * @param batch
     * @param <T>
     * @return
     */
    public static <T> List<List<T>> spliteList(List<T> list, int batch) {
        Double size = Math.ceil(list.size() * 1.0f / batch);
        List result = new ArrayList<List<T>>();
        for (int i = 0; i < size.intValue(); i++) {
            int fromIndex = i * batch;
            int endIndex = fromIndex + batch > list.size() ? list.size() : fromIndex + batch;
            result.add(list.subList(fromIndex, endIndex));
        }
        return result;
    }

    /**
     * 数组大小
     * @param list
     * @return
     */
    public static int size(Object[] list) {
        if (list == null) {
            return 0;
        } else {
            return list.length;
        }
    }

    /**
     * 集合大小
     * @param list
     * @return
     */
    public static int size(List<?> list) {
        if (list == null) {
            return 0;
        } else {
            return list.size();
        }
    }

    /**
     * 集合去重
     * @param list
     * @return
     */
    public static List<String> uniq(List<String> list) {
        if (list == null) {
            return null;
        }
        List<String> result = new ArrayList<String>();
        for (String str : list) {
            if (!result.contains(str)) {
                result.add(str);
            }
        }
        return result;
    }


    /**
     * 删除空记录
     * @param list
     * @return
     */
    public static List<?> removeNull(List<?> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        // 删除空记录
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next == null) {
                iterator.remove();
            }
        }
        return list;
    }


    /***
     * list转Map
     *
     * @param <E>
     * @param list
     *            需要转换的集合 不能有重复的元素
     * @param filedName（多个以,分割）
     *            相当于Map中的key
     * @return
     */
    @SuppressWarnings("unchecked")
    public static <E> Map<String, E> listToMap(List<E> list, String filedName) throws Exception {
        if (null == filedName || "".equals(filedName)) {
            throw new Exception("入参不能为空");
        }
        if (null == list) {
            throw new Exception("list入参不能为空");
        }
        String[] filedNameArr = filedName.split(",");// 字段名称
        List<String> nameListtemp = new ArrayList<String>();// 方法名称
        for (String s : filedNameArr) {
            if (null == s || "".equals(s)) {
                throw new Exception("入参不能为空");
            }
            String name = "get" + StrUtil.makeFirstLetterUpperCase(s);
            nameListtemp.add(name);
        }
        final List<String> nameList = nameListtemp;
        Map<String, E> returnMap = new HashMap<String, E>();
        if (list.get(0) instanceof Map) {
            for (int i = 0; i < list.size(); i++) {
                Map<String, Object> ma = (Map<String, Object>) list.get(i);
                String returnStr = "";
                for (int j = 0; j < filedNameArr.length; j++) {
                    /*
                     * System.out.println(list.get(i).getClass()); Class<?> c =
                     * list.get(i).getClass(); Method m = c.getMethod("get");
                     */
                    returnStr = returnStr + ma.get(filedNameArr[j]).toString();
                    if (j < filedNameArr.length - 1) {
                        returnStr = returnStr + ",";
                    }
                }
                returnMap.put(returnStr, list.get(i));
            }
        } else {
            returnMap = Maps.uniqueIndex(list, new Function<E, String>() {
                public String apply(E site) {
                    String returnStr = "";
                    List<Method> methodList = new ArrayList<Method>();
                    try {
                        for (int i = 0; i < nameList.size(); i++) {
                            methodList.add(site.getClass().getMethod(nameList.get(i)));
                        }
                        if (methodList.size() > 0) {
                            for (int i = 0; i < methodList.size(); i++) {
                                returnStr = returnStr + (methodList.get(i).invoke(site) == null ? ""
                                        : methodList.get(i).invoke(site));
                                if (i < methodList.size() - 1) {
                                    returnStr = returnStr + ",";
                                }
                            }
                        }
                        return returnStr;
                    } catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    } catch (SecurityException e) {
                        e.printStackTrace();
                    } catch (IllegalAccessException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    } catch (IllegalArgumentException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    } catch (InvocationTargetException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }
                    return returnStr;
                }
            });
        }
        if (null == returnMap) {
            return null;
        }
        return returnMap;
    }

    /**
     * 用来去掉List中空值和相同项的。
     *
     * @param list
     * @return
     */
    public static List<String> removeSameItem(List<String> list) {
        List<String> difList = new ArrayList<String>();
        for (String t : list) {
            if (t != null && !difList.contains(t)) {
                difList.add(t);
            }
        }
        return difList;
    }

    /**
     * 转换String数组
     * @param list
     * @return
     */
    public static String[] toArray(List<String> list) {
        if(ListUtil.isEmpty(list)){
            return new String[]{};
        }
        //return list.toArray(new String[]{});
        return list.stream().toArray(String[]::new);
    }

    /**
     * 数组转集合
     * @param arrays
     * @return
     */
    public static List<String>  toArray(String[] arrays) {
        if(ArrayUtil.isEmpty(arrays)){
            return null;
        }
        List<String> list = Stream.of(arrays).collect(Collectors.toList());
        return list;
    }



    /**
     * use java.utils.Stream java8
     *
     * iterator -> list
     * @param iterator
     * @param <T>
     * @return
     */
    public static <T> ArrayList<T> toArrayList(final Iterator<T> iterator) {

        return StreamSupport.stream(Spliterators
                .spliteratorUnknownSize(iterator, Spliterator.ORDERED), false)
                .collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> ArrayList<T> newArrayList(Collection<T> src) {
        ArrayList<T> l = new ArrayList<T>(src.size());
        Iterator<T> ite=src.iterator();
        while(ite.hasNext()){
            l.add(ite.next());
        }
        return l;
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T... t) {
        ArrayList<T> l = new ArrayList<T>();
        Collections.addAll(l, t);
        return l;
    }

    @SafeVarargs
    public static <T> LinkedList<T> newLinkedList(T... t) {
        LinkedList<T> l = new LinkedList<T>();
        Collections.addAll(l, t);
        return l;
    }




}
