package cn.dolphin.core.util;

import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;

import java.util.HashMap;
import java.util.Map;

/**
 * 表达式解析引擎
 * commons-jexl包可以将字符串转化为可执行的java代码，支持各种表达式运算，包括且、或、异或、取反以及加减乘除等各种运算，且支持动态加载类与方法，功能强大
 */
public class Jexl3Util {
    /**
     * 构造函数禁止new
     */
    private Jexl3Util() {

    }

    /**
     * java将字符串转换成可执行代码 工具类
     * 使用commons的jexl可实现将字符串变成可执行代码的功能
     * @param jexlExp 字符串表达式
     * @param map 参数
     * @return
     */
    public static Object convertToCode(String jexlExp, Map<String, Object> map) {
        JexlEngine jexl = new JexlEngine();
        Expression expression = jexl.createExpression(jexlExp);
        JexlContext jc = new MapContext();
        for (String key : map.keySet()) {
            jc.set(key, map.get(key));
        }
        if (null == expression.evaluate(jc)) {
            return "";
        }
        return expression.evaluate(jc);
    }


    public static void main(String[] args) {
        // 执行字符串表达式：(k-(x-y)*0.1)，进行计算
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("k", 10);
        map.put("x", 2);
        map.put("y", 4);
        String formula = "k-(x-y)*0.1";
        Object result = convertToCode(formula,map);
        System.out.println(result);
        System.out.println(10 - (2 - 4) * 0.1);
    }




}
