//package cn.dolphin.core.util;
//
//import cn.dolphin.core.bean.HttpJson;
//import cn.dolphin.core.consts.CharsetConstant;
//import cn.dolphin.core.json.FastJsonUtil;
//import cn.dolphin.core.result.ApiResult;
//import com.alibaba.fastjson.JSON;
//import com.alibaba.fastjson.JSONObject;
//import com.alibaba.fastjson.serializer.SerializerFeature;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.io.IOUtils;
//import org.apache.http.*;
//import org.apache.http.client.ClientProtocolException;
//import org.apache.http.client.config.RequestConfig;
//import org.apache.http.client.entity.UrlEncodedFormEntity;
//import org.apache.http.client.methods.*;
//import org.apache.http.client.utils.URIBuilder;
//import org.apache.http.conn.ssl.NoopHostnameVerifier;
//import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
//import org.apache.http.entity.ContentType;
//import org.apache.http.entity.StringEntity;
//import org.apache.http.entity.mime.MultipartEntityBuilder;
//import org.apache.http.entity.mime.content.FileBody;
//import org.apache.http.impl.client.CloseableHttpClient;
//import org.apache.http.impl.client.HttpClients;
//import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
//import org.apache.http.message.BasicNameValuePair;
//import org.apache.http.util.EntityUtils;
//import org.springframework.util.ObjectUtils;
//
//import javax.net.ssl.SSLContext;
//import javax.net.ssl.TrustManager;
//import javax.net.ssl.X509TrustManager;
//import java.io.*;
//import java.nio.charset.Charset;
//import java.security.GeneralSecurityException;
//import java.security.cert.X509Certificate;
//import java.util.*;
//
//
///**
// * 封装httpClient
// */
//@SuppressWarnings("all")
//@Slf4j
//public class HttpUtil {
//
//    private static PoolingHttpClientConnectionManager connMgr;
//    private static RequestConfig requestConfig;
//    private static final int MAX_TIMEOUT = 120000000;
//
//    static {
//        // 设置连接池
//        connMgr = new PoolingHttpClientConnectionManager();
//        // 设置连接池大小
//        connMgr.setMaxTotal(100);
//        connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());
//
//        RequestConfig.Builder configBuilder = RequestConfig.copy(RequestConfig.DEFAULT);
//        // 设置连接超时
//        configBuilder.setConnectTimeout(MAX_TIMEOUT);
//        // 设置读取超时
//        configBuilder.setSocketTimeout(MAX_TIMEOUT);
//        // 设置从连接池获取连接实例的超时
//        configBuilder.setConnectionRequestTimeout(MAX_TIMEOUT);
//
//        requestConfig = configBuilder.build();
//    }
//
//    /**
//     * 发送 GET 请求（HTTP），不带输入数据
//     */
//    public static Map<Integer, String> doGet(String url) {
//        return doGet(url, new HashMap<>());
//    }
//
//    /**
//     * 发送 GET 请求（HTTP），K-V形式
//     */
//    public static Map<Integer, String> doGet(String url, Map<String, Object> params) {
//        String apiUrl = url;
//        StringBuffer param = new StringBuffer();
//        int i = 0;
//        for (String key : params.keySet()) {
//            if (i == 0)
//                param.append("?");
//            else
//                param.append("&");
//            param.append(key).append("=").append(params.get(key));
//            i++;
//        }
//        apiUrl += param;
//        Integer statusCode;
//        String result = null;
//        Map<Integer, String> dataResult = new HashMap<Integer, String>();
////        HttpClient httpclient = HttpClientBuilder.create().build();
//        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
//        try {
//            HttpGet httpGet = new HttpGet(apiUrl);
//            httpGet.setConfig(requestConfig);
//            HttpResponse response = httpclient.execute(httpGet);
//            statusCode = response.getStatusLine().getStatusCode();
//
//            HttpEntity entity = response.getEntity();
//            if (entity != null) {
//                InputStream inStream = entity.getContent();
//                result = IOUtils.toString(inStream, "UTF-8");
//            }
//            dataResult.put(statusCode, result);
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//        return dataResult;
//    }
//
//    /**
//     * 发送 GET 请求（HTTP），K-V形式，带身份令牌的head
//     */
//    public static Map<Integer, String> doGet(String url, Map<String, Object> params, String token) {
//        String apiUrl = url;
//        StringBuffer param = new StringBuffer();
//        int i = 0;
//        for (String key : params.keySet()) {
//            if (i == 0)
//                param.append("?");
//            else
//                param.append("&");
//            param.append(key).append("=").append(params.get(key));
//            i++;
//        }
//        apiUrl += param;
//        Integer statusCode;
//        String result = null;
//        Map<Integer, String> dataResult = new HashMap<Integer, String>();
////        HttpClient httpclient = HttpClientBuilder.create().build();
//        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
//        try {
//            HttpGet httpGet = new HttpGet(apiUrl);
//            httpGet.setConfig(requestConfig);
//            httpGet.setHeader("token", token);
//            HttpResponse response = httpclient.execute(httpGet);
//            statusCode = response.getStatusLine().getStatusCode();
//
//            HttpEntity entity = response.getEntity();
//            if (entity != null) {
//                InputStream inStream = entity.getContent();
//                result = IOUtils.toString(inStream, "UTF-8");
//            }
//            dataResult.put(statusCode, result);
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//        return dataResult;
//    }
//
//    /**
//     * 发送get请求;不带请求头和请求参数
//     */
//    public static String doGetString(String url) throws Exception {
//        return doGetString(url, null, null);
//    }
//
//    /**
//     * 发送get请求;带请求参数
//     */
//    public static String doGetString(String url, Map<String, String> params) throws Exception {
//        return doGetString(url, null, params);
//    }
//
//    /**
//     * 发送get请求;带请求头和请求参数
//     */
//    public static String doGetString(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
//        // 创建httpClient对象
//        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
//        // 创建访问地址
//        URIBuilder uriBuilder = new URIBuilder(url);
//        if (!ObjectUtils.isEmpty(params)) {
//            params.forEach(uriBuilder::setParameter);
//        }
//
//        // 创建http对象
//        HttpGet httpGet = new HttpGet(uriBuilder.build());
//        // 设置请求超时时间及响应超时时间
//        httpGet.setConfig(requestConfig);
//
//        // 设置请求头
//        packageHeader(headers, httpGet);
//
//        // 执行请求获取响应体并释放资源
//        return getHttpClientResult(httpClient, httpGet);
//    }
//
//
//
//    /**
//     * 发送post请求;带请求参数
//     */
//    public static String doPostString(String url, Map<String, String> params) throws IOException {
//        return doPostString(url, null, params);
//    }
//
//    /**
//     * 发送post请求;不带请求头和请求参数
//     */
//    public static String doPostString(String url) throws IOException {
//        return doPostString(url, null, null);
//    }
//
//    /**
//     * 发送post请求;带请求头和请求参数
//     */
//    public static String doPostString(String url, Map<String, String> headers, Map<String, String> params) throws IOException {
//        // 创建httpClient对象
//        //CloseableHttpClient httpClient = HttpClients.createDefault();
//        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
//        // 创建http对象
//        HttpPost httpPost = new HttpPost(url);
//
//        // 设置请求超时时间及响应超时时间
//        httpPost.setConfig(requestConfig);
//
//        // 设置请求头
//        /*httpPost.setHeader("Cookie", "");
//        httpPost.setHeader("Connection", "keep-alive");
//        httpPost.setHeader("Accept", "application/json");
//        httpPost.setHeader("Accept-Language", "zh-CN,zh;q=0.9");
//        httpPost.setHeader("Accept-Encoding", "gzip, deflate, br");
//        httpPost.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36");*/
//        // 设置请求头
//        packageHeader(headers, httpPost);
//
//        // 封装请求参数
//        packageParam(params, httpPost);
//
//        // 执行请求获取响应体并释放资源
//        return getHttpClientResult(httpClient, httpPost);
//    }
//
//
//    /**
//     * 发送 POST 请求（HTTP），不带输入数据
//     */
//    public static String doPost(String apiUrl) {
//        return doPost(apiUrl, new HashMap<>());
//    }
//
//    /**
//     * 发送 POST 请求（HTTP），K-V形式
//     */
//    public static String doPost(String apiUrl, Map<String, Object> params) {
//       // CloseableHttpClient httpClient = HttpClients.createDefault();
//        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
//        String httpStr = null;
//        HttpPost httpPost = new HttpPost(apiUrl);
//        CloseableHttpResponse response = null;
//
//        try {
//            httpPost.setConfig(requestConfig);
//            List<NameValuePair> pairList = new ArrayList<>(params.size());
//            for (Map.Entry<String, Object> entry : params.entrySet()) {
//                NameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
//                pairList.add(pair);
//            }
//            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8"));
//            formEntity.setContentType("application/x-www-form-urlencoded; charset=UTF-8");
//            httpPost.setEntity(formEntity);
//            response = httpClient.execute(httpPost);
//            //System.out.println(response.toString());
//            HttpEntity entity = response.getEntity();
//            httpStr = EntityUtils.toString(entity, "UTF-8");
//        } catch (IOException e) {
//            e.printStackTrace();
//        } finally {
//            if (response != null) {
//                try {
//                    EntityUtils.consume(response.getEntity());
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            }
//        }
//        return httpStr;
//    }
//
//    /**
//     * 发送 POST 请求（HTTP），JSON形式
//     */
//    public static String doPost(String apiUrl, Object json) {
//        //CloseableHttpClient httpClient = HttpClients.createDefault();
//        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
//        String httpStr = null;
//        HttpPost httpPost = new HttpPost(apiUrl);
//        CloseableHttpResponse response = null;
//
//        try {
//            httpPost.setConfig(requestConfig);
//            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");//解决中文乱码问题
//            stringEntity.setContentEncoding("UTF-8");
//            stringEntity.setContentType("application/json");
//            httpPost.setEntity(stringEntity);
//            response = httpClient.execute(httpPost);
//            HttpEntity entity = response.getEntity();
//            //System.out.println(response.getStatusLine().getStatusCode());
//            httpStr = EntityUtils.toString(entity, "UTF-8");
//        } catch (IOException e) {
//            e.printStackTrace();
//        } finally {
//            if (response != null) {
//                try {
//                    EntityUtils.consume(response.getEntity());
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            }
//        }
//        return httpStr;
//    }
//
//
//
//    /**
//     * 发送 POST 请求（HTTP），JSON形式
//     */
//    public static HttpJson doPostJson(String apiUrl, JSONObject json) {
//        //CloseableHttpClient httpClient = HttpClients.createDefault();
//        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
//        String httpStr = null;
//        HttpPost httpPost = new HttpPost(apiUrl);
//        CloseableHttpResponse response = null;
//        HttpJson httpJson = new HttpJson();
//
//        try {
//            httpPost.setConfig(requestConfig);
//            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
//            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");//解决中文乱码问题
//            stringEntity.setContentEncoding("UTF-8");
//            stringEntity.setContentType("application/json");
//            httpPost.setEntity(stringEntity);
//            response = httpClient.execute(httpPost);
//            HttpEntity entity = response.getEntity();
//            httpJson.setStatus(response.getStatusLine().getStatusCode());
//            //System.out.println(response.getStatusLine().getStatusCode());
//            //httpStr = EntityUtils.toString(entity, "UTF-8");
//            httpStr = JSON.toJSONString(JSON.parseObject(EntityUtils.toString(entity, "UTF-8")), SerializerFeature.WriteMapNullValue);//解决Unicode编码转换Utf8,解决微null丢字段
//            httpJson.setJson(JSONObject.parseObject(httpStr));
//        } catch (IOException e) {
//            //e.printStackTrace();
//            httpJson.setStatus(500);
//            httpJson.setJson(JSONObject.parseObject(FastJsonUtil.toJson(ApiResult.error("服务器访问异常，请检查服务器是否启动"))));
//        } finally {
//            if (response != null) {
//                try {
//                    EntityUtils.consume(response.getEntity());
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            }
//        }
//        return httpJson;
//    }
//
//    /**
//     * 发送 POST 请求（HTTP），JSON形式 ，带身份令牌的head
//     */
//    public static HttpJson doPostJson(String apiUrl, JSONObject json, String token) {
//        //CloseableHttpClient httpClient = HttpClients.createDefault();
//        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
//        String httpStr = null;
//        HttpPost httpPost = new HttpPost(apiUrl);
//        CloseableHttpResponse response = null;
//        HttpJson httpJson = new HttpJson();
//
//        try {
//            httpPost.setConfig(requestConfig);
//            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
//            httpPost.setHeader("token", token);
//            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");//解决中文乱码问题
//            stringEntity.setContentEncoding("UTF-8");
//            stringEntity.setContentType("application/json");
//            httpPost.setEntity(stringEntity);
//            response = httpClient.execute(httpPost);
//            HttpEntity entity = response.getEntity();
//            httpJson.setStatus(response.getStatusLine().getStatusCode());
//            //System.out.println(response.getStatusLine().getStatusCode());
//            //httpStr = EntityUtils.toString(entity, "UTF-8");
//            httpStr = JSON.toJSONString(JSON.parseObject(EntityUtils.toString(entity, "UTF-8")), SerializerFeature.WriteMapNullValue);//解决Unicode编码转换Utf8,解决微null丢字段
//            httpJson.setJson(JSONObject.parseObject(httpStr));
//        } catch (IOException e) {
//            //e.printStackTrace();
//            httpJson.setStatus(500);
//            httpJson.setJson(JSONObject.parseObject(FastJsonUtil.toJson(ApiResult.error("服务器访问异常，请检查服务器是否启动"))));
//        } finally {
//            if (response != null) {
//                try {
//                    EntityUtils.consume(response.getEntity());
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            }
//        }
//        return httpJson;
//    }
//
//    /**
//     * 发送 SSL POST 请求（HTTPS），K-V形式
//     */
//    public static String doPostSSL(String apiUrl, Map<String, Object> params) {
//        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
//        HttpPost httpPost = new HttpPost(apiUrl);
//        CloseableHttpResponse response = null;
//        String httpStr = null;
//
//        try {
//            httpPost.setConfig(requestConfig);
//            List<NameValuePair> pairList = new ArrayList<>(params.size());
//            for (Map.Entry<String, Object> entry : params.entrySet()) {
//                NameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
//                pairList.add(pair);
//            }
//            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8"));
//            formEntity.setContentType("application/x-www-form-urlencoded; charset=UTF-8");
//            httpPost.setEntity(formEntity);
//            response = httpClient.execute(httpPost);
//            int statusCode = response.getStatusLine().getStatusCode();
//            if (statusCode != HttpStatus.SC_OK) {
//                return null;
//            }
//            HttpEntity entity = response.getEntity();
//            if (entity == null) {
//                return null;
//            }
//            httpStr = EntityUtils.toString(entity, "utf-8");
//        } catch (Exception e) {
//            e.printStackTrace();
//        } finally {
//            if (response != null) {
//                try {
//                    EntityUtils.consume(response.getEntity());
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            }
//        }
//        return httpStr;
//    }
//
//    /**
//     * 发送 SSL POST 请求（HTTPS），JSON形式
//     */
//    public static String doPostSSL(String apiUrl, Object json) {
//        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
//        HttpPost httpPost = new HttpPost(apiUrl);
//        CloseableHttpResponse response = null;
//        String httpStr = null;
//
//        try {
//            httpPost.setConfig(requestConfig);
//            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");
//            stringEntity.setContentEncoding("UTF-8");
//            stringEntity.setContentType("application/json");
//            httpPost.setEntity(stringEntity);
//            response = httpClient.execute(httpPost);
//            int statusCode = response.getStatusLine().getStatusCode();
//            if (statusCode != HttpStatus.SC_OK) {
//                return null;
//            }
//            HttpEntity entity = response.getEntity();
//            if (entity == null) {
//                return null;
//            }
//            httpStr = EntityUtils.toString(entity, "utf-8");
//        } catch (Exception e) {
//            e.printStackTrace();
//        } finally {
//            if (response != null) {
//                try {
//                    EntityUtils.consume(response.getEntity());
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            }
//        }
//        return httpStr;
//    }
//
//
//    /**
//     * 文件上传
//     * @param url 上传路径
//     * @param file 上传文件
//     * @return
//     */
//    public static String upload(String url, File file) {
//        List<File> files=new ArrayList<File>();
//        files.add(file);
//        return uploads(url, files, null);
//    }
//    /**
//     * 文件上传
//     * @param url
//     * @return
//     */
//    public static String upload(String url,Map<String, Object> paramMap) {
//        try {
//            //CloseableHttpClient httpClient = HttpClientBuilder.create().build();
//            CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
//            HttpPost httpPost = new HttpPost(url);
//
//            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
//            // 封装参数
//            if (paramMap != null && paramMap.size() > 0) {
//                for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
//                    String key = entry.getKey();
//                    Object value = entry.getValue();
//                    if(value instanceof File){
//                        File file=(File)value;
//                        //builder.addBinaryBody( key, file, ContentType.MULTIPART_FORM_DATA, file.getName());
//                        builder.addPart(key, new FileBody(file));
//                    }else{
//                        if(value!=null){
//                            builder.addTextBody(key,value.toString(), ContentType.create("application/x-www-form-urlencoded", "UTF-8"));
//                        }
//                    }
//                }
//            }
//            builder.setCharset(Charset.forName("utf-8"));
//            builder.setContentType(ContentType.MULTIPART_FORM_DATA);
//            HttpEntity entity = builder.build();
//            httpPost.setEntity(entity);
//            CloseableHttpResponse response = httpClient.execute(httpPost);
//            return EntityUtils.toString(response.getEntity(), "UTF-8");
//        } catch (ClientProtocolException e) {
//            e.printStackTrace();
//        } catch (ParseException e) {
//            e.printStackTrace();
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//        return null;
//    }
//
//    /**
//     * 文件上传
//     * @param url
//     * @return
//     */
//    public static String uploads(String url, List<File> files, Map<String, Object> paramMap) {
//        try {
//            //CloseableHttpClient httpClient = HttpClientBuilder.create().build();
//            CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
//            HttpPost httpPost = new HttpPost(url);
//
//            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
//            // 封装文件
//            if (files != null && files.size() > 0) {
//                for (File file : files) {
//                    builder.addBinaryBody(UUID.randomUUID().toString(), file, ContentType.MULTIPART_FORM_DATA, file.getName());
//                }
//            }
//            // 封装参数
//            if (paramMap != null && paramMap.size() > 0) {
//                for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
//                    builder.addTextBody(entry.getKey(), entry.getValue().toString(),
//                            ContentType.create("application/x-www-form-urlencoded", "UTF-8"));
//                }
//            }
//            builder.setCharset(Charset.forName("utf-8"));
//            builder.setContentType(ContentType.MULTIPART_FORM_DATA);
//            HttpEntity entity = builder.build();
//            httpPost.setEntity(entity);
//            CloseableHttpResponse response = httpClient.execute(httpPost);
//            return EntityUtils.toString(response.getEntity(), "UTF-8");
//        } catch (ClientProtocolException e) {
//            e.printStackTrace();
//        } catch (ParseException e) {
//            e.printStackTrace();
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//        return null;
//    }
//
//    /**
//     * 执行文件下载
//     *
//     * @param httpClient      HttpClient客户端实例，传入null会自动创建一个
//     * @param remoteFileUrl   远程下载文件地址
//     * @param localFilePath   本地存储文件地址
//     * @param charset         请求编码，默认UTF-8
//     * @param closeHttpClient 执行请求结束后是否关闭HttpClient客户端实例
//     * @return
//     * @throws ClientProtocolException
//     * @throws IOException
//     */
//    public static boolean executeDownloadFile(String remoteFileUrl, String localFilePath, String charset, boolean closeHttpClient) throws ClientProtocolException, IOException {
//
//        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
//
//        CloseableHttpResponse response = null;
//        InputStream in = null;
//        FileOutputStream fout = null;
//        try {
//            HttpGet httpget = new HttpGet(remoteFileUrl);
//            response = httpClient.execute(httpget);
//            HttpEntity entity = response.getEntity();
//            if (entity == null) {
//                return false;
//            }
//            in = entity.getContent();
//            File file = new File(localFilePath);
//            fout = new FileOutputStream(file);
//            int l;
//            byte[] tmp = new byte[1024];
//            while ((l = in.read(tmp)) != -1) {
//                fout.write(tmp, 0, l);
//                // 注意这里如果用OutputStream.write(buff)的话，图片会失真
//            }
//            // 将文件输出到本地
//            fout.flush();
//            EntityUtils.consume(entity);
//            return true;
//        }catch (Exception e){
//            return false;
//        }finally {
//            // 关闭低层流。
//            if (fout != null) {
//                try {
//                    fout.close();
//                } catch (Exception e) {
//                }
//            }
//            if (response != null) {
//                try {
//                    response.close();
//                } catch (Exception e) {
//                }
//            }
//            if (closeHttpClient && httpClient != null) {
//                try {
//                    httpClient.close();
//                } catch (Exception e) {
//                }
//            }
//        }
//    }
//
//
//
//    /**
//     * 检测连接
//     * @param url
//     * @return
//     */
//    public static boolean ping(String url){
//        log.info(url);
//        try {
////            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
//            CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
//            HttpGet http = new HttpGet(url);
//            CloseableHttpResponse response = httpClient.execute(http);
//            int statusCode = response.getStatusLine().getStatusCode();
//            String responseString = EntityUtils.toString(response.getEntity(), "UTF-8");
//            return statusCode==200&&responseString!=null&&responseString.length()>0;
//        } catch (Exception e) {
//            log.error("检测连接异常",e);
//        }
//        return false;
//    }
//
//    /**
//     * 创建SSL安全连接
//     */
//    private static SSLConnectionSocketFactory createSSLConnSocketFactory() {
//        SSLConnectionSocketFactory sslSocketFactory = null;
//        try {
//            X509TrustManager trustManager = new X509TrustManager() {
//                @Override public X509Certificate[] getAcceptedIssuers() {
//                    return null;
//                }
//                @Override public void checkClientTrusted(X509Certificate[] xcs, String str) {}
//                @Override public void checkServerTrusted(X509Certificate[] xcs, String str) {}
//            };
//            SSLContext sslContext = SSLContext.getInstance(SSLConnectionSocketFactory.TLS);
//            sslContext.init(null, new TrustManager[] { trustManager }, null);
//            sslSocketFactory = new SSLConnectionSocketFactory(sslContext, NoopHostnameVerifier.INSTANCE);
//        } catch (GeneralSecurityException e) {
//            e.printStackTrace();
//        }
//        return sslSocketFactory;
//    }
//
//    /**
//     * map转化url参数，如果是特殊字符会进行转义
//     */
//    private static String mapToUrlParams(Map<String, String> map) {
//        if (map == null) {
//            return null;
//        }
//        StringBuilder sb = new StringBuilder();
//        for (Map.Entry<String, String> entry : map.entrySet()) {
//            String key = entry.getKey();
//            String value = entry.getValue();
//            if (value == null) {
//                sb.append(key).append("=").append("&");
//            } else {
//                sb.append(key).append("=").append(value).append("&");
//            }
//        }
//        StringBuilder result = sb.deleteCharAt(sb.length() - 1);
//        return result.toString();
//    }
//
//    /**
//     * 封装请求参数
//     */
//    private static void packageParam(Map<String, String> params, HttpEntityEnclosingRequestBase httpMethod) throws UnsupportedEncodingException {
//        if (!ObjectUtils.isEmpty(params)) {
//            List<NameValuePair> nameValuePairs = new ArrayList<>();
//            params.forEach((key, value) -> nameValuePairs.add(new BasicNameValuePair(key, value)));
//            httpMethod.setEntity(new UrlEncodedFormEntity(nameValuePairs, CharsetConstant.UTF8));
//        }
//    }
//
//    /**
//     * 设置请求头
//     */
//    private static void packageHeader(Map<String, String> headers, HttpRequestBase httpMethod) {
//        if (!ObjectUtils.isEmpty(headers)) {
//            headers.forEach(httpMethod::setHeader);
//        }
//    }
//
//    /**
//     * 执行请求获取响应体并释放资源
//     */
//    private static String getHttpClientResult(CloseableHttpClient httpClient, HttpRequestBase httpMethod) throws IOException {
//        // 执行请求
//        CloseableHttpResponse httpResponse = null;
//        try {
//            // 获取响应体
//            httpResponse = httpClient.execute(httpMethod);
//            String content = "";
//            if (!ObjectUtils.isEmpty(httpResponse) && !ObjectUtils.isEmpty(httpResponse.getEntity())) {
//                content = EntityUtils.toString(httpResponse.getEntity(), CharsetConstant.UTF8);
//            }
//            return content;
//        } finally {
//            // 释放资源
//            if (!ObjectUtils.isEmpty(httpResponse)) {
//                httpResponse.close();
//            }
//            if (!ObjectUtils.isEmpty(httpClient)) {
//                httpClient.close();
//            }
//        }
//    }
//
//
//}
