package cn.dolphin.core.util;

import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;

/**
 * 处理数据的工具类
 * 公用的处理数据的方法写在这里
 * 计算百分比
 */
@Slf4j
public class DataHandleUtil {

    /**
     * 把上面得到的百分比转为字符串类型的小数  保留两位小数
     */
    public static BigDecimal perToDecimal(String percent){
        String decimal = percent.substring(0,percent.indexOf("%"));
        BigDecimal bigDecimal = new BigDecimal(decimal);
        bigDecimal.divide(new BigDecimal("100"), 4, BigDecimal.ROUND_HALF_UP);
        return bigDecimal;
    }

    /**
     * 保留n为小数
     *
     * @param d
     * @param bit
     * @return
     */
    public static Double doubleBit(Double d, Integer bit) {
        if (d == null || bit == null)
            return null;
        BigDecimal bg = new BigDecimal(d).setScale(bit, RoundingMode.DOWN);
        return bg.doubleValue();
    }


    /**
     * 计算百分比 保留留n位小数
     *
     * @param divisor 第一位数
     * @param dividend 第二位数
     * @param bit 保留小数位
     * @return
     */
    public static String division(Float divisor, Float dividend, Integer bit) {
        if (dividend == null || divisor == null || bit == null)
            return null;
        NumberFormat numberFormat = NumberFormat.getInstance();
        // 设置精确到小数点后2位
        numberFormat.setMaximumFractionDigits(bit);
        String result = numberFormat.format(divisor / dividend * 100);
        return result + "%";
    }


    /**
     * 计算百分比 整数
     *
     * @param divisor
     * @param dividend
     * @return
     */
    public static String division(Integer divisor, Integer dividend) {
        if (dividend == null || divisor == null){
            return null;
        }
        String division = division(CastUtil.castFloat(divisor), CastUtil.castFloat(dividend), 2);
        return division;
    }

    /**
     * 计算百分比 整数
     *
     * @param divisor
     * @param dividend
     * @return
     */
    public static String division(Float divisor, Float dividend) {
        return division(divisor, dividend, 2);
    }




    public static void main(String[] args) {
        System.out.println(DataHandleUtil.division(CastUtil.castFloat((8.8-8)), CastUtil.castFloat(8)));
        System.out.println(DataHandleUtil.perToDecimal("67.89%"));

        // BigDecimal比较大小，还是用compareTo方法比较靠谱，改为compareTo之后，上面四个case返回的结果都是相等：
        // 比较
        BigDecimal newZero = new BigDecimal(0.0);
        System.out.println(BigDecimal.ZERO.compareTo(newZero));

        BigDecimal stringNewZero = new BigDecimal("0.0");
        System.out.println(BigDecimal.ZERO.compareTo(stringNewZero));

        BigDecimal noScaleZero = BigDecimal.valueOf(0.0);
        System.out.println(BigDecimal.ZERO.compareTo(noScaleZero));

        BigDecimal scaleZero = BigDecimal.valueOf(0.0).setScale(1);
        System.out.println(BigDecimal.ZERO.compareTo(scaleZero));
        System.out.println(1);
        System.out.println(BigDecimalUtil.lessEqual(DataHandleUtil.perToDecimal("20.01%"), CastUtil.castStringToBigDecimal("20")));
    }



}
