package cn.dolphin.core.util;

import cn.dolphin.core.consts.P;
import com.alibaba.fastjson.JSON;
import org.apache.commons.beanutils.ConvertUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 压制任何警告的数据格式转换
 */
public class ConvertUtil {

    /**
     * 分割截取转换
     * @param content 字符串，用分割符号分割
     * @param splitChar 分割符号
     * @return
     */
    public static List<Long> splitStr2LongList(String content, String splitChar) {
        if(StringUtils.isEmpty(content)){
            return new ArrayList<>();
        }

        String[] split = content.split(splitChar);
        Long[] longArr = (Long[]) ConvertUtils.convert(split, Long.class);
        // 返回值类型是ArrayList，但此ArrayList是Array的内部类,调用add()时，会报错：java.lang.UnsupportedOperationException;故需要再次构造一个新的ArrayList
        return new ArrayList<>(Arrays.asList(longArr));
    }

    /**
     * 分割截取转换
     * @param content 字符串，用分割符号分割
     * @param splitChar 分割符号
     * @return
     */
    public static String[] splitStr2StrArray(String content, String splitChar) {
        if(StringUtils.isEmpty(content)){
            return new String[]{};
        }

        String[] split = content.split(splitChar);
        return split;
    }

    public static <T, S> List<T> convertList(List<S> sourceList, Class<T> targetClazz){
        if(CollectionUtils.isEmpty(sourceList)){
            return new ArrayList<>();
        }

        return JSON.parseArray(JSON.toJSONString(sourceList), targetClazz);
    }

    @SuppressWarnings("unchecked")
    public static <T> T convert(Object obj, T def) {
        T t = (T) convert(obj, def.getClass().getName());
        return t == null ? def : t;
    }

    @SuppressWarnings("unchecked")
    public static <T> T convert(Object obj, Class<T> clazz) {
        return (T) convert(obj, clazz.getName());
    }

    public static Object convert(Object obj, String type) {
        if (obj == null) {
            return null;
        }
        switch (type) {
            case "java.lang.Object":
                return obj;
            case "java.lang.String":
                return toString(obj);
            case "java.lang.Boolean":
                return toBool(obj);
            case "boolean":
                return toBool(obj, false);
            case "java.lang.Double":
                return toDouble(obj);
            case "double":
                return toDouble(obj, 0d);
            case "java.lang.Long":
                return toLong(obj);
            case "long":
                return toLong(obj, 0L);
            case "java.lang.Float":
                return toFloat(obj);
            case "float":
                return toFloat(obj, 0f);
            case "java.lang.Integer":
                return toInteger(obj);
            case "int":
                return toInteger(obj, 0);
            case "java.math.BigDecimal":
                return toBigDecimal(obj);
            case "java.sql.Date":
                return toDate(obj);
            case "java.sql.Time":
                return toTime(obj);
            case "java.sql.Timestamp":
                return toTimestamp(obj);
            case "java.util.Date":
                return toUtilDate(obj);
            default:
                return obj;
        }
    }

    public static String toString(Object obj, String def) {
        return nvl(toString(obj), def);
    }

    public static String toString(Object obj) {
        try {
            if (obj == null)
                return null;
            if (obj instanceof Number)
                return getNf().format(((Number) obj).doubleValue());
            if (obj instanceof String)
                return obj.toString().length() == 0 ? null : obj.toString();
            return obj.toString();
        } catch (Exception e) {
            return obj.toString();
        }
    }

    public static String toString2(Object obj, String pattern, String def) {
        return nvl(toString2(obj, pattern), def);
    }

    public static String toString2(Object obj, String pattern) {
        try {
            if (obj == null) {
                return null;
            }
            if (pattern == null) {
                return toString(obj);
            }
            if (obj instanceof Number) {
                return new DecimalFormat(pattern).format(obj);
            }
            if (obj instanceof java.util.Date) {
                return new SimpleDateFormat(pattern).format(obj);
            }
            if (obj instanceof String) {
                return obj.toString().length() == 0 ? null : obj.toString();
            }
            return obj.toString();
        } catch (Exception e) {
            return obj.toString();
        }
    }

    public static BigDecimal toBigDecimal(Object obj, BigDecimal def) {
        return nvl(toBigDecimal(obj), def);
    }

    public static BigDecimal toBigDecimal(Object obj) {
        try {
            if (obj == null)
                return null;
            if (obj instanceof String) {
                String str = (String) obj;
                BigDecimal retBig = new BigDecimal(str);
                int iscale = str.indexOf(".");
                int keylen = str.length();
                if (iscale > -1) {
                    iscale = keylen - (iscale + 1);
                    return retBig.setScale(iscale, 5);
                }
                return retBig.setScale(0, 5);
            }
            if (obj instanceof BigDecimal)
                return (BigDecimal) obj;
            if (obj instanceof Number)
                return new BigDecimal(((Number) obj).doubleValue());
            return null;
        } catch (Exception e) {
            return null;
        }
    }

    public static Double toDouble(Object obj, Double def) {
        return nvl(toDouble(obj), def);
    }

    public static Double toDouble(Object obj) {
        try {
            if (obj == null)
                return null;
            if (obj instanceof String)
                return new Double(getNf().parse((String) obj).doubleValue());
            if (obj instanceof Number)
                return ((Number) obj).doubleValue();
            return null;
        } catch (Exception e) {
            return null;
        }
    }

    public static Long toLong(Object obj, Long def) {
        return nvl(toLong(obj), def);
    }

    public static Long toLong(Object obj) {
        try {
            if (obj == null)
                return null;
            if (obj instanceof String) {
                NumberFormat nf = getNf();
                nf.setMaximumFractionDigits(0);
                return new Long(nf.parse((String) obj).longValue());
            }
            if (obj instanceof Number)
                return ((Number) obj).longValue();
            return null;
        } catch (Exception e) {
            return null;
        }
    }

    public static Float toFloat(Object obj, Float def) {
        return nvl(toFloat(obj), def);
    }

    public static Float toFloat(Object obj) {
        try {
            if (obj == null)
                return null;
            if (obj instanceof Number)
                return ((Number) obj).floatValue();
            if (obj instanceof String)
                return new Float(getNf().parse((String) obj).floatValue());
            return null;
        } catch (Exception e) {
            return null;
        }
    }

    public static Integer toInteger(Object obj, Integer def) {
        return nvl(toInteger(obj), def);
    }

    public static Integer toInteger(Object obj) {
        try {
            if (obj == null)
                return null;
            if (obj instanceof Number)
                return ((Number) obj).intValue();
            if (obj instanceof String) {
                NumberFormat nf = getNf();
                nf.setMaximumFractionDigits(0);
                return new Integer(nf.parse((String) obj).intValue());
            }
            return null;
        } catch (Exception e) {
            return null;
        }
    }

    public static Boolean toBool(Object obj, Boolean def) {
        return nvl(toBool(obj), def);
    }

    public static Boolean toBool(Object obj) {
        try {
            if (obj == null)
                return null;
            if (obj instanceof String) {
                String str = ((String) obj).toLowerCase();
                return "true".equals(str)|| "1".equals(str) || "yes".equals(str) || "on".equals(str);
            }
            if (obj instanceof Number)
                return ((Number) obj).intValue() != 0;
            if (obj instanceof Boolean)
                return (Boolean) obj;
            return null;
        } catch (Exception e) {
            return null;
        }
    }

    public static java.sql.Date toDate(Object obj, String format, java.util.Date def) {
        return nvl(toDate(obj, format), new java.sql.Date(def.getTime()));
    }

    public static java.sql.Date toDate(Object obj, String format, java.sql.Date def) {
        return nvl(toDate(obj, format), def);
    }

    public static java.sql.Date toDate(Object obj) {
        return toDate(obj, P.DATE_FORMAT_DATE);
    }

    public static java.sql.Date toDate(Object obj, String format) {
        if (obj == null)
            return null;
        if (obj instanceof Long)
            return new java.sql.Date((Long) obj);
        if (obj instanceof java.util.Date)
            return new java.sql.Date(((java.util.Date) obj).getTime());
        if (obj instanceof String) {
            String str = (String) obj;
            try {
                return java.sql.Date.valueOf(str);
            } catch (IllegalArgumentException e) {
                try {
                    return new java.sql.Date(new SimpleDateFormat(format).parse(str).getTime());
                } catch (Exception e1) {
                    return null;
                }
            }
        }
        if (obj instanceof java.sql.Date)
            return (java.sql.Date) obj;
        return null;
    }

    public static java.util.Date toUtilDate(Object obj, String format, java.util.Date def) {
        return nvl(toUtilDate(obj, format), def);
    }

    public static java.util.Date toUtilDate(Object obj, String format, java.sql.Date def) {
        return nvl(toUtilDate(obj, format), def);
    }

    public static java.util.Date toUtilDate(Object obj) {
        return toUtilDate(obj, P.DATE_FORMAT_DATETIME);
    }

    public static java.util.Date toUtilDate(Object obj, String format) {
        if (obj == null)
            return null;
        if (obj instanceof java.util.Date)
            return (java.util.Date) obj;
        if (obj instanceof java.sql.Date)
            return (java.util.Date) obj;
        if (obj instanceof Long)
            return new java.util.Date((Long) obj);
        if (obj instanceof String) {
            String str = (String) obj;
            try {
                if (format == null) {
                    return java.sql.Date.valueOf(str);
                } else {
                    return new SimpleDateFormat(format).parse(str);
                }
            } catch (IllegalArgumentException | ParseException e) {
                return null;
            }
        }
        return null;
    }

    public static java.sql.Time toTime(Object obj, String format, java.util.Date def) {
        return nvl(toTime(obj, format), new java.sql.Time(def.getTime()));
    }

    public static java.sql.Time toTime(Object obj) {
        return toTime(obj, P.DATE_FORMAT_TIME);
    }

    public static java.sql.Time toTime(Object obj, String format) {
        if (obj == null)
            return null;
        if (obj instanceof Long)
            return new java.sql.Time((Long) obj);
        if (obj instanceof java.util.Date)
            return new java.sql.Time(((java.util.Date) obj).getTime());
        if (obj instanceof String) {
            String str = (String) obj;
            try {
                return java.sql.Time.valueOf(str);
            } catch (IllegalArgumentException e) {
                try {
                    return new java.sql.Time(new SimpleDateFormat(format).parse(str).getTime());
                } catch (Exception e1) {
                    return null;
                }
            }
        }
        if (obj instanceof java.sql.Time)
            return (java.sql.Time) obj;
        return null;
    }

    public static java.sql.Timestamp toTimestamp(Object obj, String format, java.util.Date def) {
        return nvl(toTimestamp(obj, format), new java.sql.Timestamp(def.getTime()));
    }

    public static java.sql.Timestamp toTimestamp(Object obj) {
        return toTimestamp(obj, P.DATE_FORMAT_DATETIME);
    }

    public static java.sql.Timestamp toTimestamp(Object obj, String format) {
        if (obj == null)
            return null;
        if (obj instanceof Long)
            return new java.sql.Timestamp((Long) obj);
        if (obj instanceof java.util.Date)
            return new java.sql.Timestamp(((java.util.Date) obj).getTime());
        if (obj instanceof String) {
            String str = (String) obj;
            try {
                return java.sql.Timestamp.valueOf(str);
            } catch (IllegalArgumentException e) {
                try {
                    return new java.sql.Timestamp(new SimpleDateFormat(format).parse(str).getTime());
                } catch (Exception e1) {
                    return null;
                }
            }
        }
        if (obj instanceof java.sql.Timestamp)
            return (java.sql.Timestamp) obj;
        return null;
    }

    private static NumberFormat getNf() {
        NumberFormat nf = NumberFormat.getNumberInstance(P.LOCALE);
        nf.setGroupingUsed(false);
        return nf;
    }

    private static final <T> T nvl(T src, T newObj) {
        return src == null ? newObj : src;
    }

}
