package cn.dolphin.core.util;

import cn.dolphin.core.consts.StringConstant;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

import java.util.*;
import java.util.stream.Collectors;


/**
 * 集合工具类
 */
@SuppressWarnings("all")
public class CollectionUtil extends org.springframework.util.CollectionUtils{

    /**
     * 集合是否为空
     *
     * @param collection 集合
     * @return 是否为空
     */
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || CollectionUtils.isEmpty(collection);
    }

    /**
     * 集合是否为非空
     *
     * @param collection 集合
     * @return 是否为非空
     */
    public static boolean isNotEmpty(Collection<?> collection) {
        return !isEmpty(collection);
    }


    /**
     * Map是否为空
     *
     * @param map 集合
     * @return 是否为空
     */
    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || MapUtils.isEmpty(map);
    }

    /**
     * Map是否为非空
     *
     * @param map 集合
     * @return 是否为非空
     */
    public static <T> boolean isNotEmpty(Map<?, ?> map) {
        return !isEmpty(map);
    }

    /**
     * 数组是否为空
     *
     * @param array 数组
     * @return 是否为空
     */
    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length <= 0;
    }

    /**
     * 数组是否为非空
     *
     * @param array 数组
     * @return 是否为非空
     */
    public static <T> boolean isNotEmpty(T[] array) {
        return !isEmpty(array);
    }


    /**
     * 判断集合的元素是否都为空
     *
     * @param collection
     * @return
     *
     */
    public static <T>boolean isAllNull(Collection<T> collection){
        for(T el : collection){
            if (el != null) {
                return true;
            }
        }
        return false;
    }

    /**
     * 添加非空元素：
     * 如果Collection为空返回false；如果elemnt为null返回false；如果都不为空则添加并返回true
     *
     * @param c
     * @param e
     * @return
     *
     */
    public static <E> boolean addNotNullElement(Collection<E> c, E e){
        if(c == null){
            return false;
        }
        if(e == null){
            return false;
        }
        c.add(e);
        return true;
    }

    /**
     * 添加非空元素集:
     * 如果Collection为空返回false；如果elemnts为空返回false；如果都不为空则添加并返回true
     *
     * @param c
     * @param es
     * @return
     *
     */
    public static <E> boolean addNotNullElements(Collection<E> c, Collection<E> es){
        if(c == null){
            return false;
        }
        if(! CollectionUtils.isEmpty(es)){
            return false;
        }
        c.addAll(es);
        return true;
    }

    /**
     * 获取List的元素：如果超出索引，返回null而不抛出异常
     *
     * @param l
     * @param index
     * @return
     *
     */
    public static<E> E getNotNullElement(List<E> l, int index){
        if(null == l){
            return null;
        }
        if(l.size() <=index){
            return null;
        }
        return l.get(index);
    }

    /**
     *
     * 切割字符串为String数组
     *
     * @param ids
     * @return
     *
     */
    public static final List<String> toStrList(String ids){
        return ArrayUtil.convertList(ids.split(StringConstant.COMMA));
    }
    /**
     *
     * 切割字符串为Integer数组
     *
     * @param ids
     * @return
     *
     */
    public static final List<Integer> toIntList(String ids){
        String[] split = ids.split(StringConstant.COMMA);
        List<Integer> ls = new ArrayList<Integer>(split.length);
        for (int i = 0; i < split.length; i++) {
            ls.add(Integer.valueOf(split[i]));
        }
        return ls;
    }

    /**
     * 切割字符串为Long数组
     *
     * @param ids
     * @return
     *
     */
    public static final List<Long> toLongList(String ids){
        String[] split = ids.split(StringConstant.COMMA);
        List<Long> ls = new ArrayList<Long>(split.length);
        for (int i = 0; i < split.length; i++) {
            ls.add(Long.valueOf(split[i]));
        }
        return ls;
    }

    /**
     * 数组转换为List
     *
     * @param es
     * @return
     *
     */
    public static<E> List<E> arrayToList(E[] es){
        List<E> list = new ArrayList<E>(es.length);
        for(E e :es){
            list.add(e);
        }
        return list;
    }

    /**
     * 集合转数组
     * 注：Java - Collection的toArray是经过复杂的反射后进行遍历，不如直接遍历效率高
     *
     * @param collection
     * @return
     *
     */
    public static String[] toArrray(Collection<String> collection){
        String[] arr = new String[collection.size()];
        int i = 0;
        for (String e : collection) {
            arr[i] = e;
            i++;
        }
        return arr;
    }

    /**
     * 集合转数组
     *
     * @param collection
     * @return
     *
     */
    public static Long[] toLongArrray(Collection<Long> collection){
        Long[] arr = new Long[collection.size()];
        int i = 0;
        for (Long e : collection) {
            arr[i] = e;
            i++;
        }
        return arr;
    }

    /**
     * 集合转数组
     *
     * @param collection
     * @return
     *
     */
    public static Integer[] toIntArrray(Collection<Integer> collection){
        Integer[] arr = new Integer[collection.size()];
        int i = 0;
        for (Integer e : collection) {
            arr[i] = e;
            i++;
        }
        return arr;
    }

    /**
     *
     * 并集
     *
     * @param t1
     * @param t2
     * @return
     *
     */
    @SuppressWarnings("unchecked")
    public static <T> Collection<T> union(Collection<T> t1,Collection<T> t2){
        return CollectionUtils.union(t1,t2);
    }
    /**
     *
     * 交集
     *
     * @param t1
     * @param t2
     * @return
     *
     */
    @SuppressWarnings("unchecked")
    public static <T> Collection<T> intersection(Collection<T> t1,Collection<T> t2){
        return CollectionUtils.intersection(t1,t2);
    }

    /**
     *
     * 差集 - 减去t1中存在的t2元素，即剩下t1中存在但t2中不存在的元素
     *
     * @param t1
     * @param t2
     * @return
     *
     */
    @SuppressWarnings("unchecked")
    public static <T> Collection<T> subtract(Collection<T> t1,Collection<T> t2){
        return CollectionUtils.subtract(t1,t2);
    }

    /**
     * 将二维Map+List，转换为三维Map+List
     * 原始：LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>
     * 目标：LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, null>>>
     *
     * @param src
     * @return
     *
     */
    public static LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>> castMap2list1ToMap3null1(LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>> src){
        LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>> desc = new LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>>();
        LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>> map1 = null;
        LinkedHashMap<String, ArrayList<String>> map2 = null;
        LinkedHashMap<String, ArrayList<String>> map3 = null;
        ArrayList<String> list1 = null;
        Set<String> twSet = src.keySet();
        for(String key : twSet){
            map2 = src.get(key);
            Set<String> keySet = map2.keySet();
            map1 = new LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>();
            for(String k : keySet){
                list1 = map2.get(k);
                map3 = new LinkedHashMap<String, ArrayList<String>>();
                for(String s :list1){
                    map3.put(s, null);
                }
                map1.put(k,map3);
            }
            desc.put(key, map1);
        }
        return desc;
    }

    /**
     * 将一维Map+List，转换为三维Map+List
     * 原始：LinkedHashMap<String, ArrayList<String>>
     * 目标：LinkedHashMap<String, LinkedHashMap<String, null>>
     *
     * @param src
     * @return
     *
     */
    public static LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>> castMap1list1ToMap3null2( LinkedHashMap<String, ArrayList<String>> src){
        LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>> desc = new LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>>();
        LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>> map1 = null;
        ArrayList<String> list1 = null;
        Set<String> mcSet = src.keySet();
        for(String key : mcSet){
            list1 = src.get(key);
            map1 = new LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>>();
            for(String k : list1){
                map1.put(k, null);
            }
            desc.put(key, map1);
        }
        return desc;
    }

    /**
     * 拆分集合
     *
     * @param resList
     *            要拆分的集合
     * @param splitSize
     *            每个集合的元素个数
     * @return 返回拆分后的各个集合
     */
    public static <T> List<List<T>> split(List<T> resList, int splitSize) {
        if (resList == null || resList.isEmpty())
            return new ArrayList<>();

        if (splitSize < 1) {
            splitSize = 1;
        }

        List<List<T>> ret = new ArrayList<List<T>>();
        int size = resList.size();
        if (size <= splitSize) { // 数据量不足count指定的大小
            ret.add(resList);
            return ret;
        }

        // 拆分子集个数
        int subCount = size / splitSize;
        // 前面的集合，每个大小都是count个元素
        for (int i = 0; i < subCount; i++) {
            List<T> itemList = new ArrayList<T>();
            for (int j = 0; j < splitSize; j++) {
                itemList.add(resList.get(i * splitSize + j));
            }
            ret.add(itemList);
        }

        int last = size % splitSize;
        // last的进行处理
        if (last > 0) {
            List<T> itemList = new ArrayList<T>();
            for (int i = 0; i < last; i++) {
                itemList.add(resList.get(subCount * splitSize + i));
            }
            ret.add(itemList);
        }
        return ret;
    }

    /**
     * 获取去除重复数据后的集合,根据泛型的hashCode以及equals方法判断是否为相同数据
     * @param collection
     * @param <T>
     * @return
     */
    public static <T> List<T> distinctList(Collection<T> collection){
        if(CollectionUtils.isEmpty(collection)){
            return Collections.emptyList();
        }
        return collection.stream().distinct().collect(Collectors.toList());
    }
}
