package cn.dolphin.core.util;


/**
 * 类型判断工具类
 */
public class BaseTypeUtil {

    /**
     * 判断是否是基本类型
     * int long void short
     * @param clazz
     * @return
     */
    public static boolean judgeBaseType(Class clazz){

        return clazz.isPrimitive();
    }

    /**
     * 判断是否是包装类型的基本类型
     * @param clazz
     * @return
     */
    public static boolean isWrapClass(Class clazz) {
        try {
            return ((Class) clazz.getField("TYPE").get(null)).isPrimitive();
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 排除基本类型和包装类型
     * @param clazz
     * @return
     */
    public static boolean judgeBaseTypeExcludeWrapClass(Class clazz){

        if (judgeBaseType(clazz)){
            return true;
        }
        return isWrapClass(clazz);
    }
}
