package cn.dolphin.core.token;

import cn.dolphin.core.date.DateUtil;
import cn.dolphin.core.util.MD5Util;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;

/**
 * token
 */
@Data
public abstract class Token implements Serializable {

    private static final long serialVersionUID = -3871114844781666085L;

    private static final String KEY="69391a3ffeb649cb92acfffc3b2de8da"; //盐,暂时写死，后期通过xml读取

    private long issueTime;//发型时间
    private long expires;//到期时间，时间戳
    private String issuer;//发型者
    private String signature;//签名


    /**
     * 获取token
     *
     * UUID+盐经过MD5加密两次
     * @return
     */
    protected static String getToken(){
        return MD5Util.encryptPasswordTwice(UUID.randomUUID()+KEY+ DateUtil.getMillis(new Date()));
    }

    /**
     * 获取token
     * @param appkey 开发者ID
     * @return
     */
    protected static String getToken(String appkey){
        return MD5Util.encryptPasswordTwice(UUID.randomUUID()+appkey+ DateUtil.getMillis(new Date()));
    }

    /**
     * 签名
     * @return
     */
    protected static String getUniqueID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }





}
