package cn.dolphin.core.token;

import cn.dolphin.core.date.TimeUtil;
import cn.dolphin.core.util.SystemClock;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.entity.ContentType;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeMap;


/**
 * MD5签名和验签
 */
public class MD5SignHelper {


    /**
     * 将字符串MD5加码 生成32位md5码
     * @param inStr
     * @return
     */
    public static String md5(String inStr) {
        try {
            return DigestUtils.md5Hex(inStr.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5签名过程中出现错误");
        }
    }

    /**
     * 签名字符串
     * @param params
     * @param appSecretName
     * @param appSecret
     * @return
     */
    public static String sign(Map<String, String> params, String appSecretName, String appSecret) {
        StringBuilder valueSb = new StringBuilder();
        params.put(appSecretName, appSecret);
        // 将参数以参数名的字典升序排序
        Map<String, String> sortParams = new TreeMap<String, String>(params);
        Set<Entry<String, String>> entrys = sortParams.entrySet();
        // 遍历排序的字典,并拼接value1+value2......格式
        for (Entry<String, String> entry : entrys) {
            valueSb.append(entry.getValue());
        }
        params.remove(appSecretName);
        return md5(valueSb.toString());
    }

    public static void main(String[] args) {


       String[] s =  ContentType.APPLICATION_JSON.toString().split(";");
        System.out.println(s[0]);
        if(ContentType.APPLICATION_JSON.toString().contains("application/json")){
            System.out.println(1);
        }

        System.out.println(ContentType.APPLICATION_JSON);
        long date = SystemClock.now();
        System.out.println(date);
        System.out.println(TimeUtil.getSeconds(date));
        Map<String,String> map = new HashMap<String, String>();
        map.put("appkey","APP190314183106100");
//        map.put("token","7c7567f63f72b8e605caf820bb3ca6ae");
        map.put("timestamp","1548271379");
        map.put("userId","3");
        map.put("isForever","1");
        map.put("isSuper","1");
        //86b63483461adc90f8406df55d781727
        //e64c5390dc1d5ac6905930196a392d5e
        System.out.println(sign(map,"appsecret","E038972454FA7CBCCAA95B45609B9455"));


    }

}
