package cn.dolphin.core.token;

import cn.dolphin.core.util.MD5Util;
import cn.dolphin.core.util.SequenceNumberUtil;

import java.util.UUID;

/**
 * app token
 */
public class AppToken extends Token {

    public final static int APPTOKEN_STORE_EXPIRES_SECOND = 60 * 60 * 24 * 30;// token有效期 30天
    public final static long APPTOKEN_STORE_EXPIRES_MILLISECOND = (long) APPTOKEN_STORE_EXPIRES_SECOND * 1000L;// token有效期 30天

    private AppToken() {
//        this.setIssueTime(System.currentTimeMillis());
//        this.setExpires(System.currentTimeMillis() + APPTOKEN_STORE_EXPIRES_MILLISECOND);
//        this.setSignature(getUniqueID());//TODO

    }

    /**
     * 应用标识key
     * @return
     */
    public static String appKey(){
        return SequenceNumberUtil.getInstance().generate("APP");
    }

    /**
     * 加密算法secret
     * @return
     */
    public static String appSecret(){
        return MD5Util.md5(UUID.randomUUID().toString().toUpperCase()).toUpperCase();
    }

}
