package cn.dolphin.core.spring;

import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.stereotype.Component;
import org.springframework.util.StringValueResolver;

/**
 * 获取spring中的属性
 */
@Component
public class SpringPropertiesUtil implements EmbeddedValueResolverAware {
    private static StringValueResolver stringValueResolver;

    public SpringPropertiesUtil() {
        super();
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        stringValueResolver = resolver;
    }

    public static String getPropertiesValue(String name){
        name = "${" + name + "}";
        return stringValueResolver.resolveStringValue(name);
    }
}
