package cn.dolphin.core.spring;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * (SpringDispatcher持有类，用于获取request、session等对象、获取Controller层bean对象)
 */
public class SpringDispatcher {

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static HttpSession getSession() {
        return getRequest().getSession();
    }

    public static ServletContext getServletContext() {
        return getSession().getServletContext();
    }

    public static WebApplicationContext getWebApplicationContext() {
//        return RequestContextUtils.getWebApplicationContext(getRequest());//5.0废弃
        return RequestContextUtils.findWebApplicationContext(getRequest());
    }

    @SuppressWarnings("unchecked")
    public static <T> T getBean(String name) {
        return (T)getWebApplicationContext().getBean(name);
    }

    @SuppressWarnings("unchecked")
    public static <T> T getBean(Class<?> clazz) {
        return (T)getWebApplicationContext().getBean(clazz);
    }
}
