package cn.dolphin.core.spring;

import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.ServletContext;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SpringBeanService {

    private static SpringBeanService sbs;
    private static Object obj = new Object();
    private ApplicationContext ctx;
    private Hashtable<String, Object> map;

    public static void initService(ServletContext sc) {
        if (sbs == null) {
            synchronized (obj) {
                if (sbs == null) {
                    sbs = new SpringBeanService();
                    sbs.ctx = WebApplicationContextUtils.getWebApplicationContext(sc);
                }
            }
        }
    }

    public static void setServices(String services) {
        if ((services != null) && (services.length() > 0)) {
            String[] servs = services.split(",");
            setServices(servs);
        }
    }

    public static void setServices(Properties services) {
        if ((!services.isEmpty()) && (services.size() > 0)) {
            String[] servs = new String[services.size()];
            int i = 0;
            for (Enumeration<Object> e = services.elements(); e.hasMoreElements();) {
                servs[i] = e.nextElement().toString();
                i++;
            }
            setServices(servs);
        }
    }

    private static void setServices(String[] services) {
        try {
            if ((services != null) && (services.length > 0)) {
                for (int i = 0; i < services.length; i++) {
                    if ((services[i] != null) && (services[i].trim().length() > 0)) {
                        if (sbs.map == null) {
                            synchronized (obj) {
                                if (sbs.map == null) {
                                    sbs.map = new Hashtable();
                                    sbs.map.put(services[i], sbs.ctx.getBean(services[i]));
                                }
                            }
                        }
                        if (!sbs.map.containsKey(services[i])) {
                            synchronized (obj) {
                                if (!sbs.map.containsKey(services[i])) {
                                    sbs.map.put(services[i], sbs.ctx.getBean(services[i]));
                                }
                            }
                        }
                    }
                }
            }
        }catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getService(String serName) {
        Object obj = null;
        if ((sbs != null) && (sbs.map != null)) {
            obj = sbs.map.get(serName);
        }
        return obj;
    }


}
